<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplyPriceToType StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates the specific traveler, itinerary, paid origin/destination or flight segment a priced item applies to.
 * @subpackage Structs
 */
class ApplyPriceToType extends AbstractStructBase
{
    /**
     * The SeatRPH
     * Meta information extracted from the WSDL
     * - documentation: A reference to a seat product ID.
     * - use: optional
     * @var string
     */
    public $SeatRPH;
    /**
     * The OtherServiceRPH
     * Meta information extracted from the WSDL
     * - documentation: A reference to a unique other service ID defined elsewhere in this message.
     * - use: optional
     * @var string
     */
    public $OtherServiceRPH;
    /**
     * Constructor method for ApplyPriceToType
     * @uses ApplyPriceToType::setSeatRPH()
     * @uses ApplyPriceToType::setOtherServiceRPH()
     * @param string $seatRPH
     * @param string $otherServiceRPH
     */
    public function __construct($seatRPH = null, $otherServiceRPH = null)
    {
        $this
            ->setSeatRPH($seatRPH)
            ->setOtherServiceRPH($otherServiceRPH);
    }
    /**
     * Get SeatRPH value
     * @return string|null
     */
    public function getSeatRPH()
    {
        return $this->SeatRPH;
    }
    /**
     * Set SeatRPH value
     * @param string $seatRPH
     * @return \StructType\ApplyPriceToType
     */
    public function setSeatRPH($seatRPH = null)
    {
        // validation for constraint: string
        if (!is_null($seatRPH) && !is_string($seatRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatRPH, true), gettype($seatRPH)), __LINE__);
        }
        $this->SeatRPH = $seatRPH;
        return $this;
    }
    /**
     * Get OtherServiceRPH value
     * @return string|null
     */
    public function getOtherServiceRPH()
    {
        return $this->OtherServiceRPH;
    }
    /**
     * Set OtherServiceRPH value
     * @param string $otherServiceRPH
     * @return \StructType\ApplyPriceToType
     */
    public function setOtherServiceRPH($otherServiceRPH = null)
    {
        // validation for constraint: string
        if (!is_null($otherServiceRPH) && !is_string($otherServiceRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherServiceRPH, true), gettype($otherServiceRPH)), __LINE__);
        }
        $this->OtherServiceRPH = $otherServiceRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ApplyPriceToType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
