<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AppliedRuleType StructType
 * Meta information extracted from the WSDL
 * - documentation: A choice between a default rule indicator OR a rule name and version number. | Applied rule information, including category, rule identifier and rule descriptions.
 * @subpackage Structs
 */
class AppliedRuleType extends AbstractStructBase
{
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - documentation: Advanced Purchase | Weekend Stay | The applied rule category.
     * - use: required
     * @var string
     */
    public $Category;
    /**
     * The DefaultUsedInd
     * Meta information extracted from the WSDL
     * - documentation: If true, a system default rule was used.
     * - choice: DefaultUsedInd | RuleInfo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var bool
     */
    public $DefaultUsedInd;
    /**
     * The RuleInfo
     * Meta information extracted from the WSDL
     * - choice: DefaultUsedInd | RuleInfo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\RuleInfo
     */
    public $RuleInfo;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Description[]
     */
    public $Description;
    /**
     * Constructor method for AppliedRuleType
     * @uses AppliedRuleType::setCategory()
     * @uses AppliedRuleType::setDefaultUsedInd()
     * @uses AppliedRuleType::setRuleInfo()
     * @uses AppliedRuleType::setDescription()
     * @param string $category
     * @param bool $defaultUsedInd
     * @param \StructType\RuleInfo $ruleInfo
     * @param \StructType\Description[] $description
     */
    public function __construct($category = null, $defaultUsedInd = null, \StructType\RuleInfo $ruleInfo = null, array $description = array())
    {
        $this
            ->setCategory($category)
            ->setDefaultUsedInd($defaultUsedInd)
            ->setRuleInfo($ruleInfo)
            ->setDescription($description);
    }
    /**
     * Get Category value
     * @return string
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\AppliedRuleType
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get DefaultUsedInd value
     * @return bool|null
     */
    public function getDefaultUsedInd()
    {
        return isset($this->DefaultUsedInd) ? $this->DefaultUsedInd : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDefaultUsedInd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDefaultUsedInd method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDefaultUsedIndForChoiceConstraintsFromSetDefaultUsedInd($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'RuleInfo',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DefaultUsedInd can\'t be set as the property %s is already set. Only one property must be set among these properties: DefaultUsedInd, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DefaultUsedInd value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $defaultUsedInd
     * @return \StructType\AppliedRuleType
     */
    public function setDefaultUsedInd($defaultUsedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultUsedInd) && !is_bool($defaultUsedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultUsedInd, true), gettype($defaultUsedInd)), __LINE__);
        }
        // validation for constraint: choice(DefaultUsedInd, RuleInfo)
        if ('' !== ($defaultUsedIndChoiceErrorMessage = self::validateDefaultUsedIndForChoiceConstraintsFromSetDefaultUsedInd($defaultUsedInd))) {
            throw new \InvalidArgumentException($defaultUsedIndChoiceErrorMessage, __LINE__);
        }
        if (is_null($defaultUsedInd) || (is_array($defaultUsedInd) && empty($defaultUsedInd))) {
            unset($this->DefaultUsedInd);
        } else {
            $this->DefaultUsedInd = $defaultUsedInd;
        }
        return $this;
    }
    /**
     * Get RuleInfo value
     * @return \StructType\RuleInfo|null
     */
    public function getRuleInfo()
    {
        return isset($this->RuleInfo) ? $this->RuleInfo : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRuleInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRuleInfo method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRuleInfoForChoiceConstraintsFromSetRuleInfo($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DefaultUsedInd',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RuleInfo can\'t be set as the property %s is already set. Only one property must be set among these properties: RuleInfo, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RuleInfo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RuleInfo $ruleInfo
     * @return \StructType\AppliedRuleType
     */
    public function setRuleInfo(\StructType\RuleInfo $ruleInfo = null)
    {
        // validation for constraint: choice(DefaultUsedInd, RuleInfo)
        if ('' !== ($ruleInfoChoiceErrorMessage = self::validateRuleInfoForChoiceConstraintsFromSetRuleInfo($ruleInfo))) {
            throw new \InvalidArgumentException($ruleInfoChoiceErrorMessage, __LINE__);
        }
        if (is_null($ruleInfo) || (is_array($ruleInfo) && empty($ruleInfo))) {
            unset($this->RuleInfo);
        } else {
            $this->RuleInfo = $ruleInfo;
        }
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\Description[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $appliedRuleTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$appliedRuleTypeDescriptionItem instanceof \StructType\Description) {
                $invalidValues[] = is_object($appliedRuleTypeDescriptionItem) ? get_class($appliedRuleTypeDescriptionItem) : sprintf('%s(%s)', gettype($appliedRuleTypeDescriptionItem), var_export($appliedRuleTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \StructType\Description, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\Description[] $description
     * @return \StructType\AppliedRuleType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\Description $item
     * @return \StructType\AppliedRuleType
     */
    public function addToDescription(\StructType\Description $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Description) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \StructType\Description, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AppliedRuleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
