<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryServiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Any service or product offered on a train in conjunction with basic rail accommodations, such as vehicle transport, pet transport and restaurant car service. Refer to OpenTravel Rail Ancillary Service (RAS) code list.
 * @subpackage Structs
 */
class AncillaryServiceType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: A short description of the ancillary service.
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * Constructor method for AncillaryServiceType
     * @uses AncillaryServiceType::setDescription()
     * @param string $description
     */
    public function __construct($description = null)
    {
        $this
            ->setDescription($description);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\AncillaryServiceType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AncillaryServiceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
