<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryServiceDetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Detailed information about an ancillary item component, including name, descriptions, pricing and multimedia.
 * @subpackage Structs
 */
class AncillaryServiceDetailType extends AirAncillaryServiceType
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the ancillary item.
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The ShortDescription
     * Meta information extracted from the WSDL
     * - documentation: A short description of the ancillary item.
     * - use: optional
     * @var string
     */
    public $ShortDescription;
    /**
     * The LongDescription
     * Meta information extracted from the WSDL
     * - documentation: A detailed description of the ancillary item.
     * - use: optional
     * @var string
     */
    public $LongDescription;
    /**
     * Constructor method for AncillaryServiceDetailType
     * @uses AncillaryServiceDetailType::setName()
     * @uses AncillaryServiceDetailType::setShortDescription()
     * @uses AncillaryServiceDetailType::setLongDescription()
     * @param string $name
     * @param string $shortDescription
     * @param string $longDescription
     */
    public function __construct($name = null, $shortDescription = null, $longDescription = null)
    {
        $this
            ->setName($name)
            ->setShortDescription($shortDescription)
            ->setLongDescription($longDescription);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\AncillaryServiceDetailType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ShortDescription value
     * @return string|null
     */
    public function getShortDescription()
    {
        return $this->ShortDescription;
    }
    /**
     * Set ShortDescription value
     * @param string $shortDescription
     * @return \StructType\AncillaryServiceDetailType
     */
    public function setShortDescription($shortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shortDescription) && !is_string($shortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortDescription, true), gettype($shortDescription)), __LINE__);
        }
        $this->ShortDescription = $shortDescription;
        return $this;
    }
    /**
     * Get LongDescription value
     * @return string|null
     */
    public function getLongDescription()
    {
        return $this->LongDescription;
    }
    /**
     * Set LongDescription value
     * @param string $longDescription
     * @return \StructType\AncillaryServiceDetailType
     */
    public function setLongDescription($longDescription = null)
    {
        // validation for constraint: string
        if (!is_null($longDescription) && !is_string($longDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longDescription, true), gettype($longDescription)), __LINE__);
        }
        $this->LongDescription = $longDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AncillaryServiceDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
