<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryServiceActionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Airline or ATPCO encoded service family with product group(s), sub-group(s) with required, include or exclude indicators.
 * @subpackage Structs
 */
class AncillaryServiceActionType extends AbstractStructBase
{
    /**
     * The ProductGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProductGroup[]
     */
    public $ProductGroup;
    /**
     * The CodeSource
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CodeSource;
    /**
     * The ServiceCode
     * Meta information extracted from the WSDL
     * - documentation: (Definition) The Service Type defines which data is being requested flight-related optional services, merchandise, baggage allowance, baggage charges, etc.). | The service family type code. Select a pre-defined value from the list,
     * or use the "Other_" value in combination with the @ExtServiceCode attribute.
     * - use: optional
     * @var string
     */
    public $ServiceCode;
    /**
     * The ExtServiceCode
     * Meta information extracted from the WSDL
     * - documentation: NOTE: Any extended enumeration values should be agreed upon between trading partners prior to use. | A string value that represents an extended enumerated value for the @ServiceCode. To use this feature, select the "Other_" item from
     * the ServiceCode list.
     * - use: optional
     * @var string
     */
    public $ExtServiceCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: A description of the service family.
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique ID for this service family that is referenced elsewhere in this schema.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The ResultsAction
     * Meta information extracted from the WSDL
     * - documentation: An indicator if the service code is required and/or should be included or excluded from the offer results.
     * - use: optional
     * @var string
     */
    public $ResultsAction;
    /**
     * Constructor method for AncillaryServiceActionType
     * @uses AncillaryServiceActionType::setProductGroup()
     * @uses AncillaryServiceActionType::setCodeSource()
     * @uses AncillaryServiceActionType::setServiceCode()
     * @uses AncillaryServiceActionType::setExtServiceCode()
     * @uses AncillaryServiceActionType::setDescription()
     * @uses AncillaryServiceActionType::setRPH()
     * @uses AncillaryServiceActionType::setResultsAction()
     * @param \StructType\ProductGroup[] $productGroup
     * @param string $codeSource
     * @param string $serviceCode
     * @param string $extServiceCode
     * @param string $description
     * @param string $rPH
     * @param string $resultsAction
     */
    public function __construct(array $productGroup = array(), $codeSource = null, $serviceCode = null, $extServiceCode = null, $description = null, $rPH = null, $resultsAction = null)
    {
        $this
            ->setProductGroup($productGroup)
            ->setCodeSource($codeSource)
            ->setServiceCode($serviceCode)
            ->setExtServiceCode($extServiceCode)
            ->setDescription($description)
            ->setRPH($rPH)
            ->setResultsAction($resultsAction);
    }
    /**
     * Get ProductGroup value
     * @return \StructType\ProductGroup[]|null
     */
    public function getProductGroup()
    {
        return $this->ProductGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setProductGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductGroupForArrayConstraintsFromSetProductGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ancillaryServiceActionTypeProductGroupItem) {
            // validation for constraint: itemType
            if (!$ancillaryServiceActionTypeProductGroupItem instanceof \StructType\ProductGroup) {
                $invalidValues[] = is_object($ancillaryServiceActionTypeProductGroupItem) ? get_class($ancillaryServiceActionTypeProductGroupItem) : sprintf('%s(%s)', gettype($ancillaryServiceActionTypeProductGroupItem), var_export($ancillaryServiceActionTypeProductGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductGroup property can only contain items of type \StructType\ProductGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductGroup[] $productGroup
     * @return \StructType\AncillaryServiceActionType
     */
    public function setProductGroup(array $productGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($productGroupArrayErrorMessage = self::validateProductGroupForArrayConstraintsFromSetProductGroup($productGroup))) {
            throw new \InvalidArgumentException($productGroupArrayErrorMessage, __LINE__);
        }
        $this->ProductGroup = $productGroup;
        return $this;
    }
    /**
     * Add item to ProductGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductGroup $item
     * @return \StructType\AncillaryServiceActionType
     */
    public function addToProductGroup(\StructType\ProductGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductGroup) {
            throw new \InvalidArgumentException(sprintf('The ProductGroup property can only contain items of type \StructType\ProductGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductGroup[] = $item;
        return $this;
    }
    /**
     * Get CodeSource value
     * @return string|null
     */
    public function getCodeSource()
    {
        return $this->CodeSource;
    }
    /**
     * Set CodeSource value
     * @param string $codeSource
     * @return \StructType\AncillaryServiceActionType
     */
    public function setCodeSource($codeSource = null)
    {
        // validation for constraint: string
        if (!is_null($codeSource) && !is_string($codeSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeSource, true), gettype($codeSource)), __LINE__);
        }
        $this->CodeSource = $codeSource;
        return $this;
    }
    /**
     * Get ServiceCode value
     * @return string|null
     */
    public function getServiceCode()
    {
        return $this->ServiceCode;
    }
    /**
     * Set ServiceCode value
     * @uses \EnumType\AncillaryServiceFamilyEnum::valueIsValid()
     * @uses \EnumType\AncillaryServiceFamilyEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceCode
     * @return \StructType\AncillaryServiceActionType
     */
    public function setServiceCode($serviceCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AncillaryServiceFamilyEnum::valueIsValid($serviceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AncillaryServiceFamilyEnum', is_array($serviceCode) ? implode(', ', $serviceCode) : var_export($serviceCode, true), implode(', ', \EnumType\AncillaryServiceFamilyEnum::getValidValues())), __LINE__);
        }
        $this->ServiceCode = $serviceCode;
        return $this;
    }
    /**
     * Get ExtServiceCode value
     * @return string|null
     */
    public function getExtServiceCode()
    {
        return $this->ExtServiceCode;
    }
    /**
     * Set ExtServiceCode value
     * @param string $extServiceCode
     * @return \StructType\AncillaryServiceActionType
     */
    public function setExtServiceCode($extServiceCode = null)
    {
        // validation for constraint: string
        if (!is_null($extServiceCode) && !is_string($extServiceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extServiceCode, true), gettype($extServiceCode)), __LINE__);
        }
        $this->ExtServiceCode = $extServiceCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\AncillaryServiceActionType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\AncillaryServiceActionType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get ResultsAction value
     * @return string|null
     */
    public function getResultsAction()
    {
        return $this->ResultsAction;
    }
    /**
     * Set ResultsAction value
     * @uses \EnumType\IncludeExcludeType::valueIsValid()
     * @uses \EnumType\IncludeExcludeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultsAction
     * @return \StructType\AncillaryServiceActionType
     */
    public function setResultsAction($resultsAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IncludeExcludeType::valueIsValid($resultsAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IncludeExcludeType', is_array($resultsAction) ? implode(', ', $resultsAction) : var_export($resultsAction, true), implode(', ', \EnumType\IncludeExcludeType::getValidValues())), __LINE__);
        }
        $this->ResultsAction = $resultsAction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AncillaryServiceActionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
