<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Amount StructType
 * Meta information extracted from the WSDL
 * - documentation: Tax amount or percentage information. | Fee amount or percentage.
 * - type: Money
 * - use: optional
 * @subpackage Structs
 */
class Amount extends AbstractStructBase
{
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - choice: Currency | AlternateCurrency | Percent | Currency | AlternateCurrency | Percent
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Currency
     */
    public $Currency;
    /**
     * The AlternateCurrency
     * Meta information extracted from the WSDL
     * - choice: Currency | AlternateCurrency | Percent | Currency | AlternateCurrency | Percent
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\AlternateCurrency
     */
    public $AlternateCurrency;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: Fee percentage. | Example: 6.25 | Note: This is a percentage of another amount that this fee or tax is based on.
     * - base: xs:decimal
     * - choice: Currency | AlternateCurrency | Percent | Currency | AlternateCurrency | Percent
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxInclusive: 100.00
     * - minInclusive: 0.00
     * - type: Percentage
     * - use: optional
     * @var float
     */
    public $Percent;
    /**
     * Constructor method for Amount
     * @uses Amount::setCurrency()
     * @uses Amount::setAlternateCurrency()
     * @uses Amount::setPercent()
     * @param \StructType\Currency $currency
     * @param \StructType\AlternateCurrency $alternateCurrency
     * @param float $percent
     */
    public function __construct(\StructType\Currency $currency = null, \StructType\AlternateCurrency $alternateCurrency = null, $percent = null)
    {
        $this
            ->setCurrency($currency)
            ->setAlternateCurrency($alternateCurrency)
            ->setPercent($percent);
    }
    /**
     * Get Currency value
     * @return \StructType\Currency|null
     */
    public function getCurrency()
    {
        return isset($this->Currency) ? $this->Currency : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCurrencyForChoiceConstraintsFromSetCurrency($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AlternateCurrency',
            'Percent',
            'AlternateCurrency',
            'Percent',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Currency can\'t be set as the property %s is already set. Only one property must be set among these properties: Currency, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Currency value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Currency $currency
     * @return \StructType\Amount
     */
    public function setCurrency(\StructType\Currency $currency = null)
    {
        // validation for constraint: choice(Currency, AlternateCurrency, Percent, Currency, AlternateCurrency, Percent)
        if ('' !== ($currencyChoiceErrorMessage = self::validateCurrencyForChoiceConstraintsFromSetCurrency($currency))) {
            throw new \InvalidArgumentException($currencyChoiceErrorMessage, __LINE__);
        }
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->Currency);
        } else {
            $this->Currency = $currency;
        }
        return $this;
    }
    /**
     * Get AlternateCurrency value
     * @return \StructType\AlternateCurrency|null
     */
    public function getAlternateCurrency()
    {
        return isset($this->AlternateCurrency) ? $this->AlternateCurrency : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAlternateCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternateCurrency method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAlternateCurrencyForChoiceConstraintsFromSetAlternateCurrency($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Currency',
            'Percent',
            'Currency',
            'Percent',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AlternateCurrency can\'t be set as the property %s is already set. Only one property must be set among these properties: AlternateCurrency, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AlternateCurrency value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AlternateCurrency $alternateCurrency
     * @return \StructType\Amount
     */
    public function setAlternateCurrency(\StructType\AlternateCurrency $alternateCurrency = null)
    {
        // validation for constraint: choice(Currency, AlternateCurrency, Percent, Currency, AlternateCurrency, Percent)
        if ('' !== ($alternateCurrencyChoiceErrorMessage = self::validateAlternateCurrencyForChoiceConstraintsFromSetAlternateCurrency($alternateCurrency))) {
            throw new \InvalidArgumentException($alternateCurrencyChoiceErrorMessage, __LINE__);
        }
        if (is_null($alternateCurrency) || (is_array($alternateCurrency) && empty($alternateCurrency))) {
            unset($this->AlternateCurrency);
        } else {
            $this->AlternateCurrency = $alternateCurrency;
        }
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return isset($this->Percent) ? $this->Percent : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPercent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPercent method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePercentForChoiceConstraintsFromSetPercent($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Currency',
            'AlternateCurrency',
            'Currency',
            'AlternateCurrency',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Percent can\'t be set as the property %s is already set. Only one property must be set among these properties: Percent, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Percent value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $percent
     * @return \StructType\Amount
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        // validation for constraint: choice(Currency, AlternateCurrency, Percent, Currency, AlternateCurrency, Percent)
        if ('' !== ($percentChoiceErrorMessage = self::validatePercentForChoiceConstraintsFromSetPercent($percent))) {
            throw new \InvalidArgumentException($percentChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxInclusive(100.00)
        if (!is_null($percent) && $percent > 100.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100.00', var_export($percent, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($percent) && $percent < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($percent, true)), __LINE__);
        }
        if (is_null($percent) || (is_array($percent) && empty($percent))) {
            unset($this->Percent);
        } else {
            $this->Percent = $percent;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Amount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
