<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AllianceConsortiumType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides the effective and expiry dates for the alliance partnership. | Identification of the alliance or partnership in which the business entity is a member. | Provides information about alliance partnerships and consortiums of
 * members grouped together to obtain trading partner agreements for travel service and privileges.
 * @subpackage Structs
 */
class AllianceConsortiumType extends AbstractStructBase
{
    /**
     * The AllianceMember
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AllianceMember[]
     */
    public $AllianceMember;
    /**
     * Constructor method for AllianceConsortiumType
     * @uses AllianceConsortiumType::setAllianceMember()
     * @param \StructType\AllianceMember[] $allianceMember
     */
    public function __construct(array $allianceMember = array())
    {
        $this
            ->setAllianceMember($allianceMember);
    }
    /**
     * Get AllianceMember value
     * @return \StructType\AllianceMember[]|null
     */
    public function getAllianceMember()
    {
        return $this->AllianceMember;
    }
    /**
     * This method is responsible for validating the values passed to the setAllianceMember method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllianceMember method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllianceMemberForArrayConstraintsFromSetAllianceMember(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $allianceConsortiumTypeAllianceMemberItem) {
            // validation for constraint: itemType
            if (!$allianceConsortiumTypeAllianceMemberItem instanceof \StructType\AllianceMember) {
                $invalidValues[] = is_object($allianceConsortiumTypeAllianceMemberItem) ? get_class($allianceConsortiumTypeAllianceMemberItem) : sprintf('%s(%s)', gettype($allianceConsortiumTypeAllianceMemberItem), var_export($allianceConsortiumTypeAllianceMemberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AllianceMember property can only contain items of type \StructType\AllianceMember, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AllianceMember value
     * @throws \InvalidArgumentException
     * @param \StructType\AllianceMember[] $allianceMember
     * @return \StructType\AllianceConsortiumType
     */
    public function setAllianceMember(array $allianceMember = array())
    {
        // validation for constraint: array
        if ('' !== ($allianceMemberArrayErrorMessage = self::validateAllianceMemberForArrayConstraintsFromSetAllianceMember($allianceMember))) {
            throw new \InvalidArgumentException($allianceMemberArrayErrorMessage, __LINE__);
        }
        $this->AllianceMember = $allianceMember;
        return $this;
    }
    /**
     * Add item to AllianceMember value
     * @throws \InvalidArgumentException
     * @param \StructType\AllianceMember $item
     * @return \StructType\AllianceConsortiumType
     */
    public function addToAllianceMember(\StructType\AllianceMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AllianceMember) {
            throw new \InvalidArgumentException(sprintf('The AllianceMember property can only contain items of type \StructType\AllianceMember, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AllianceMember[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AllianceConsortiumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
