<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTravelerType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information about the person traveling. Gender - the gender of the customer, if needed. BirthDate - Date of Birth. Currency - the preferred currency in which monetary amounts should be returned.
 * @subpackage Structs
 */
class AirTravelerType extends AbstractStructBase
{
    /**
     * The ProfileRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProfileRef
     */
    public $ProfileRef;
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - documentation: Name information of the person traveling.
     * - minOccurs: 0
     * @var mixed
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var \StructType\Telephone[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\Email[]
     */
    public $Email;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Address[]
     */
    public $Address;
    /**
     * The CustLoyalty
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\Document[]
     */
    public $Document;
    /**
     * The PassengerTypeQuantity
     * Meta information extracted from the WSDL
     * - documentation: Specifies the number of travelers of a given passenger type (e.g., Adult, Child)
     * - minOccurs: 0
     * @var mixed
     */
    public $PassengerTypeQuantity;
    /**
     * The TravelerRefNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TravelerRefNumber
     */
    public $TravelerRefNumber;
    /**
     * The FlightSegmentRPHs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FlightSegmentRPHs
     */
    public $FlightSegmentRPHs;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - documentation: Traveler's date of birth.
     * - use: optional
     * @var string
     */
    public $BirthDate;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies the code for the currency units.
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The PassengerTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code used to indicate the type of traveler that will be traveling (e.g., ADT, CHD, INF, GRP).
     * - use: optional
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * The AccompaniedByInfantInd
     * Meta information extracted from the WSDL
     * - documentation: If true, a traveler has an infant that will be sharing their seat, e.g. the infant will not require their own seat.
     * - use: optional
     * @var bool
     */
    public $AccompaniedByInfantInd;
    /**
     * The EticketInd
     * Meta information extracted from the WSDL
     * - documentation: Electronic ticket indicator.
     * - use: optional
     * @var bool
     */
    public $EticketInd;
    /**
     * The GroupInd
     * Meta information extracted from the WSDL
     * - documentation: Traveler group indicator.
     * - use: optional
     * @var bool
     */
    public $GroupInd;
    /**
     * Constructor method for AirTravelerType
     * @uses AirTravelerType::setProfileRef()
     * @uses AirTravelerType::setPersonName()
     * @uses AirTravelerType::setTelephone()
     * @uses AirTravelerType::setEmail()
     * @uses AirTravelerType::setAddress()
     * @uses AirTravelerType::setCustLoyalty()
     * @uses AirTravelerType::setDocument()
     * @uses AirTravelerType::setPassengerTypeQuantity()
     * @uses AirTravelerType::setTravelerRefNumber()
     * @uses AirTravelerType::setFlightSegmentRPHs()
     * @uses AirTravelerType::setBirthDate()
     * @uses AirTravelerType::setCurrencyCode()
     * @uses AirTravelerType::setPassengerTypeCode()
     * @uses AirTravelerType::setAccompaniedByInfantInd()
     * @uses AirTravelerType::setEticketInd()
     * @uses AirTravelerType::setGroupInd()
     * @param \StructType\ProfileRef $profileRef
     * @param mixed $personName
     * @param \StructType\Telephone[] $telephone
     * @param \StructType\Email[] $email
     * @param \StructType\Address[] $address
     * @param \StructType\CustLoyalty[] $custLoyalty
     * @param \StructType\Document[] $document
     * @param mixed $passengerTypeQuantity
     * @param \StructType\TravelerRefNumber $travelerRefNumber
     * @param \StructType\FlightSegmentRPHs $flightSegmentRPHs
     * @param string $birthDate
     * @param string $currencyCode
     * @param string $passengerTypeCode
     * @param bool $accompaniedByInfantInd
     * @param bool $eticketInd
     * @param bool $groupInd
     */
    public function __construct(\StructType\ProfileRef $profileRef = null, $personName = null, array $telephone = array(), array $email = array(), array $address = array(), array $custLoyalty = array(), array $document = array(), $passengerTypeQuantity = null, \StructType\TravelerRefNumber $travelerRefNumber = null, \StructType\FlightSegmentRPHs $flightSegmentRPHs = null, $birthDate = null, $currencyCode = null, $passengerTypeCode = null, $accompaniedByInfantInd = null, $eticketInd = null, $groupInd = null)
    {
        $this
            ->setProfileRef($profileRef)
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setAddress($address)
            ->setCustLoyalty($custLoyalty)
            ->setDocument($document)
            ->setPassengerTypeQuantity($passengerTypeQuantity)
            ->setTravelerRefNumber($travelerRefNumber)
            ->setFlightSegmentRPHs($flightSegmentRPHs)
            ->setBirthDate($birthDate)
            ->setCurrencyCode($currencyCode)
            ->setPassengerTypeCode($passengerTypeCode)
            ->setAccompaniedByInfantInd($accompaniedByInfantInd)
            ->setEticketInd($eticketInd)
            ->setGroupInd($groupInd);
    }
    /**
     * Get ProfileRef value
     * @return \StructType\ProfileRef|null
     */
    public function getProfileRef()
    {
        return $this->ProfileRef;
    }
    /**
     * Set ProfileRef value
     * @param \StructType\ProfileRef $profileRef
     * @return \StructType\AirTravelerType
     */
    public function setProfileRef(\StructType\ProfileRef $profileRef = null)
    {
        $this->ProfileRef = $profileRef;
        return $this;
    }
    /**
     * Get PersonName value
     * @return mixed|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param mixed $personName
     * @return \StructType\AirTravelerType
     */
    public function setPersonName($personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneForArrayConstraintsFromSetTelephone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airTravelerTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$airTravelerTypeTelephoneItem instanceof \StructType\Telephone) {
                $invalidValues[] = is_object($airTravelerTypeTelephoneItem) ? get_class($airTravelerTypeTelephoneItem) : sprintf('%s(%s)', gettype($airTravelerTypeTelephoneItem), var_export($airTravelerTypeTelephoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone[] $telephone
     * @return \StructType\AirTravelerType
     */
    public function setTelephone(array $telephone = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneArrayErrorMessage = self::validateTelephoneForArrayConstraintsFromSetTelephone($telephone))) {
            throw new \InvalidArgumentException($telephoneArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($telephone) && count($telephone) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone $item
     * @return \StructType\AirTravelerType
     */
    public function addToTelephone(\StructType\Telephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Telephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->Telephone) && count($this->Telephone) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->Telephone)), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \StructType\Email[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airTravelerTypeEmailItem) {
            // validation for constraint: itemType
            if (!$airTravelerTypeEmailItem instanceof \StructType\Email) {
                $invalidValues[] = is_object($airTravelerTypeEmailItem) ? get_class($airTravelerTypeEmailItem) : sprintf('%s(%s)', gettype($airTravelerTypeEmailItem), var_export($airTravelerTypeEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Email property can only contain items of type \StructType\Email, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \StructType\Email[] $email
     * @return \StructType\AirTravelerType
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($email) && count($email) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \StructType\Email $item
     * @return \StructType\AirTravelerType
     */
    public function addToEmail(\StructType\Email $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Email) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of type \StructType\Email, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->Email) && count($this->Email) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->Email)), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airTravelerTypeAddressItem) {
            // validation for constraint: itemType
            if (!$airTravelerTypeAddressItem instanceof \StructType\Address) {
                $invalidValues[] = is_object($airTravelerTypeAddressItem) ? get_class($airTravelerTypeAddressItem) : sprintf('%s(%s)', gettype($airTravelerTypeAddressItem), var_export($airTravelerTypeAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address property can only contain items of type \StructType\Address, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \StructType\Address[] $address
     * @return \StructType\AirTravelerType
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($address) && count($address) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \StructType\Address $item
     * @return \StructType\AirTravelerType
     */
    public function addToAddress(\StructType\Address $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Address) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of type \StructType\Address, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Address) && count($this->Address) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Address)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \StructType\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * This method is responsible for validating the values passed to the setCustLoyalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustLoyalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airTravelerTypeCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$airTravelerTypeCustLoyaltyItem instanceof \StructType\CustLoyalty) {
                $invalidValues[] = is_object($airTravelerTypeCustLoyaltyItem) ? get_class($airTravelerTypeCustLoyaltyItem) : sprintf('%s(%s)', gettype($airTravelerTypeCustLoyaltyItem), var_export($airTravelerTypeCustLoyaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustLoyalty property can only contain items of type \StructType\CustLoyalty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustLoyalty[] $custLoyalty
     * @return \StructType\AirTravelerType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        // validation for constraint: array
        if ('' !== ($custLoyaltyArrayErrorMessage = self::validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty($custLoyalty))) {
            throw new \InvalidArgumentException($custLoyaltyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($custLoyalty) && count($custLoyalty) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($custLoyalty)), __LINE__);
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustLoyalty $item
     * @return \StructType\AirTravelerType
     */
    public function addToCustLoyalty(\StructType\CustLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustLoyalty) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of type \StructType\CustLoyalty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->CustLoyalty) && count($this->CustLoyalty) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->CustLoyalty)), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get Document value
     * @return \StructType\Document[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentForArrayConstraintsFromSetDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airTravelerTypeDocumentItem) {
            // validation for constraint: itemType
            if (!$airTravelerTypeDocumentItem instanceof \StructType\Document) {
                $invalidValues[] = is_object($airTravelerTypeDocumentItem) ? get_class($airTravelerTypeDocumentItem) : sprintf('%s(%s)', gettype($airTravelerTypeDocumentItem), var_export($airTravelerTypeDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document property can only contain items of type \StructType\Document, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \StructType\Document[] $document
     * @return \StructType\AirTravelerType
     */
    public function setDocument(array $document = array())
    {
        // validation for constraint: array
        if ('' !== ($documentArrayErrorMessage = self::validateDocumentForArrayConstraintsFromSetDocument($document))) {
            throw new \InvalidArgumentException($documentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($document) && count($document) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($document)), __LINE__);
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \StructType\Document $item
     * @return \StructType\AirTravelerType
     */
    public function addToDocument(\StructType\Document $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of type \StructType\Document, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->Document) && count($this->Document) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->Document)), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Get PassengerTypeQuantity value
     * @return mixed|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * Set PassengerTypeQuantity value
     * @param mixed $passengerTypeQuantity
     * @return \StructType\AirTravelerType
     */
    public function setPassengerTypeQuantity($passengerTypeQuantity = null)
    {
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Get TravelerRefNumber value
     * @return \StructType\TravelerRefNumber|null
     */
    public function getTravelerRefNumber()
    {
        return $this->TravelerRefNumber;
    }
    /**
     * Set TravelerRefNumber value
     * @param \StructType\TravelerRefNumber $travelerRefNumber
     * @return \StructType\AirTravelerType
     */
    public function setTravelerRefNumber(\StructType\TravelerRefNumber $travelerRefNumber = null)
    {
        $this->TravelerRefNumber = $travelerRefNumber;
        return $this;
    }
    /**
     * Get FlightSegmentRPHs value
     * @return \StructType\FlightSegmentRPHs|null
     */
    public function getFlightSegmentRPHs()
    {
        return $this->FlightSegmentRPHs;
    }
    /**
     * Set FlightSegmentRPHs value
     * @param \StructType\FlightSegmentRPHs $flightSegmentRPHs
     * @return \StructType\AirTravelerType
     */
    public function setFlightSegmentRPHs(\StructType\FlightSegmentRPHs $flightSegmentRPHs = null)
    {
        $this->FlightSegmentRPHs = $flightSegmentRPHs;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\AirTravelerType
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\AirTravelerType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get PassengerTypeCode value
     * @return string|null
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param string $passengerTypeCode
     * @return \StructType\AirTravelerType
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($passengerTypeCode) && !is_string($passengerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passengerTypeCode, true), gettype($passengerTypeCode)), __LINE__);
        }
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
    /**
     * Get AccompaniedByInfantInd value
     * @return bool|null
     */
    public function getAccompaniedByInfantInd()
    {
        return $this->AccompaniedByInfantInd;
    }
    /**
     * Set AccompaniedByInfantInd value
     * @param bool $accompaniedByInfantInd
     * @return \StructType\AirTravelerType
     */
    public function setAccompaniedByInfantInd($accompaniedByInfantInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($accompaniedByInfantInd) && !is_bool($accompaniedByInfantInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accompaniedByInfantInd, true), gettype($accompaniedByInfantInd)), __LINE__);
        }
        $this->AccompaniedByInfantInd = $accompaniedByInfantInd;
        return $this;
    }
    /**
     * Get EticketInd value
     * @return bool|null
     */
    public function getEticketInd()
    {
        return $this->EticketInd;
    }
    /**
     * Set EticketInd value
     * @param bool $eticketInd
     * @return \StructType\AirTravelerType
     */
    public function setEticketInd($eticketInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($eticketInd) && !is_bool($eticketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eticketInd, true), gettype($eticketInd)), __LINE__);
        }
        $this->EticketInd = $eticketInd;
        return $this;
    }
    /**
     * Get GroupInd value
     * @return bool|null
     */
    public function getGroupInd()
    {
        return $this->GroupInd;
    }
    /**
     * Set GroupInd value
     * @param bool $groupInd
     * @return \StructType\AirTravelerType
     */
    public function setGroupInd($groupInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($groupInd) && !is_bool($groupInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($groupInd, true), gettype($groupInd)), __LINE__);
        }
        $this->GroupInd = $groupInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirTravelerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
