<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirSeatMarketingClassType StructType
 * Meta information extracted from the WSDL
 * - documentation: Seat marketing classification data for a section of seats within a specified aircraft equipment type.
 * @subpackage Structs
 */
class AirSeatMarketingClassType extends AbstractStructBase
{
    /**
     * The CabinInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\CabinInfo[]
     */
    public $CabinInfo;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The AirEquipType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AirEquipType;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique ID for this seat information that may be referenced elsewhere in this message.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The PurchasedSeatRPH
     * Meta information extracted from the WSDL
     * - documentation: The unique ID (defined in the ConfirmedBookingInfo/ AirItinerary/AirItinerary/ OriginDestinationOptions/ OriginDestinationOption/ FlightSegment/@RPH) attribute if this is a premium seat re-accommodation.
     * - use: optional
     * @var string
     */
    public $PurchasedSeatRPH;
    /**
     * Constructor method for AirSeatMarketingClassType
     * @uses AirSeatMarketingClassType::setCabinInfo()
     * @uses AirSeatMarketingClassType::setTPA_Extensions()
     * @uses AirSeatMarketingClassType::setAirEquipType()
     * @uses AirSeatMarketingClassType::setRPH()
     * @uses AirSeatMarketingClassType::setPurchasedSeatRPH()
     * @param \StructType\CabinInfo[] $cabinInfo
     * @param mixed $tPA_Extensions
     * @param string $airEquipType
     * @param string $rPH
     * @param string $purchasedSeatRPH
     */
    public function __construct(array $cabinInfo = array(), $tPA_Extensions = null, $airEquipType = null, $rPH = null, $purchasedSeatRPH = null)
    {
        $this
            ->setCabinInfo($cabinInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setAirEquipType($airEquipType)
            ->setRPH($rPH)
            ->setPurchasedSeatRPH($purchasedSeatRPH);
    }
    /**
     * Get CabinInfo value
     * @return \StructType\CabinInfo[]|null
     */
    public function getCabinInfo()
    {
        return $this->CabinInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setCabinInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabinInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCabinInfoForArrayConstraintsFromSetCabinInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airSeatMarketingClassTypeCabinInfoItem) {
            // validation for constraint: itemType
            if (!$airSeatMarketingClassTypeCabinInfoItem instanceof \StructType\CabinInfo) {
                $invalidValues[] = is_object($airSeatMarketingClassTypeCabinInfoItem) ? get_class($airSeatMarketingClassTypeCabinInfoItem) : sprintf('%s(%s)', gettype($airSeatMarketingClassTypeCabinInfoItem), var_export($airSeatMarketingClassTypeCabinInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CabinInfo property can only contain items of type \StructType\CabinInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CabinInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinInfo[] $cabinInfo
     * @return \StructType\AirSeatMarketingClassType
     */
    public function setCabinInfo(array $cabinInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($cabinInfoArrayErrorMessage = self::validateCabinInfoForArrayConstraintsFromSetCabinInfo($cabinInfo))) {
            throw new \InvalidArgumentException($cabinInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($cabinInfo) && count($cabinInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($cabinInfo)), __LINE__);
        }
        $this->CabinInfo = $cabinInfo;
        return $this;
    }
    /**
     * Add item to CabinInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinInfo $item
     * @return \StructType\AirSeatMarketingClassType
     */
    public function addToCabinInfo(\StructType\CabinInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CabinInfo) {
            throw new \InvalidArgumentException(sprintf('The CabinInfo property can only contain items of type \StructType\CabinInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->CabinInfo) && count($this->CabinInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->CabinInfo)), __LINE__);
        }
        $this->CabinInfo[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\AirSeatMarketingClassType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get AirEquipType value
     * @return string|null
     */
    public function getAirEquipType()
    {
        return $this->AirEquipType;
    }
    /**
     * Set AirEquipType value
     * @param string $airEquipType
     * @return \StructType\AirSeatMarketingClassType
     */
    public function setAirEquipType($airEquipType = null)
    {
        // validation for constraint: string
        if (!is_null($airEquipType) && !is_string($airEquipType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airEquipType, true), gettype($airEquipType)), __LINE__);
        }
        $this->AirEquipType = $airEquipType;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\AirSeatMarketingClassType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get PurchasedSeatRPH value
     * @return string|null
     */
    public function getPurchasedSeatRPH()
    {
        return $this->PurchasedSeatRPH;
    }
    /**
     * Set PurchasedSeatRPH value
     * @param string $purchasedSeatRPH
     * @return \StructType\AirSeatMarketingClassType
     */
    public function setPurchasedSeatRPH($purchasedSeatRPH = null)
    {
        // validation for constraint: string
        if (!is_null($purchasedSeatRPH) && !is_string($purchasedSeatRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchasedSeatRPH, true), gettype($purchasedSeatRPH)), __LINE__);
        }
        $this->PurchasedSeatRPH = $purchasedSeatRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirSeatMarketingClassType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
