<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirReservationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains all booking response information pertaining to a completed reservation.
 * @subpackage Structs
 */
class AirReservationType extends AbstractStructBase
{
    /**
     * The AirItinerary
     * Meta information extracted from the WSDL
     * - documentation: A collection of all flight segments requested for booking.
     * - minOccurs: 0
     * @var mixed
     */
    public $AirItinerary;
    /**
     * The PriceInfo
     * Meta information extracted from the WSDL
     * - documentation: Pricing information for the air itinerary to be booked e.g. this data could come from the OTA_AirPriceRS data.
     * - minOccurs: 0
     * @var mixed
     */
    public $PriceInfo;
    /**
     * The TravelerInfo
     * Meta information extracted from the WSDL
     * - documentation: All traveler information relevant to a booking request.
     * - minOccurs: 0
     * @var mixed
     */
    public $TravelerInfo;
    /**
     * The ArrangerInfo
     * Meta information extracted from the WSDL
     * - documentation: All customer information relevant to a booking request. Note a customer is defined as a person or entity associated with an air trip who will not be traveling. This is generally used to describe an individual or company paying for a
     * ticket or making the travel plans.
     * - minOccurs: 0
     * @var mixed
     */
    public $ArrangerInfo;
    /**
     * The Fulfillment
     * Meta information extracted from the WSDL
     * - documentation: All payment information relevant to a booking request.
     * - minOccurs: 0
     * @var mixed
     */
    public $Fulfillment;
    /**
     * The Ticketing
     * Meta information extracted from the WSDL
     * - documentation: Information used to specify the ticketing arrangement or a summary of the associated ticket(s).
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Ticketing;
    /**
     * The Queues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Queues
     */
    public $Queues;
    /**
     * The BookingReferenceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\BookingReferenceID[]
     */
    public $BookingReferenceID;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Textual information for the reservation.
     * - minOccurs: 0
     * @var mixed
     */
    public $Comment;
    /**
     * The PricingOverview
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PricingOverview
     */
    public $PricingOverview;
    /**
     * The EMD_Info
     * Meta information extracted from the WSDL
     * - documentation: Provides the electronic miscellaneous document information for a previously issued EMD.
     * - maxOccurs: 999
     * - minOccurs: 0
     * @var mixed[]
     */
    public $EMD_Info;
    /**
     * The LastModified
     * Meta information extracted from the WSDL
     * - documentation: Specifies the date the reservation was last modified.
     * - use: optional
     * @var string
     */
    public $LastModified;
    /**
     * Constructor method for AirReservationType
     * @uses AirReservationType::setAirItinerary()
     * @uses AirReservationType::setPriceInfo()
     * @uses AirReservationType::setTravelerInfo()
     * @uses AirReservationType::setArrangerInfo()
     * @uses AirReservationType::setFulfillment()
     * @uses AirReservationType::setTicketing()
     * @uses AirReservationType::setQueues()
     * @uses AirReservationType::setBookingReferenceID()
     * @uses AirReservationType::setComment()
     * @uses AirReservationType::setPricingOverview()
     * @uses AirReservationType::setEMD_Info()
     * @uses AirReservationType::setLastModified()
     * @param mixed $airItinerary
     * @param mixed $priceInfo
     * @param mixed $travelerInfo
     * @param mixed $arrangerInfo
     * @param mixed $fulfillment
     * @param mixed[] $ticketing
     * @param \StructType\Queues $queues
     * @param \StructType\BookingReferenceID[] $bookingReferenceID
     * @param mixed $comment
     * @param \StructType\PricingOverview $pricingOverview
     * @param mixed[] $eMD_Info
     * @param string $lastModified
     */
    public function __construct($airItinerary = null, $priceInfo = null, $travelerInfo = null, $arrangerInfo = null, $fulfillment = null, array $ticketing = array(), \StructType\Queues $queues = null, array $bookingReferenceID = array(), $comment = null, \StructType\PricingOverview $pricingOverview = null, array $eMD_Info = array(), $lastModified = null)
    {
        $this
            ->setAirItinerary($airItinerary)
            ->setPriceInfo($priceInfo)
            ->setTravelerInfo($travelerInfo)
            ->setArrangerInfo($arrangerInfo)
            ->setFulfillment($fulfillment)
            ->setTicketing($ticketing)
            ->setQueues($queues)
            ->setBookingReferenceID($bookingReferenceID)
            ->setComment($comment)
            ->setPricingOverview($pricingOverview)
            ->setEMD_Info($eMD_Info)
            ->setLastModified($lastModified);
    }
    /**
     * Get AirItinerary value
     * @return mixed|null
     */
    public function getAirItinerary()
    {
        return $this->AirItinerary;
    }
    /**
     * Set AirItinerary value
     * @param mixed $airItinerary
     * @return \StructType\AirReservationType
     */
    public function setAirItinerary($airItinerary = null)
    {
        $this->AirItinerary = $airItinerary;
        return $this;
    }
    /**
     * Get PriceInfo value
     * @return mixed|null
     */
    public function getPriceInfo()
    {
        return $this->PriceInfo;
    }
    /**
     * Set PriceInfo value
     * @param mixed $priceInfo
     * @return \StructType\AirReservationType
     */
    public function setPriceInfo($priceInfo = null)
    {
        $this->PriceInfo = $priceInfo;
        return $this;
    }
    /**
     * Get TravelerInfo value
     * @return mixed|null
     */
    public function getTravelerInfo()
    {
        return $this->TravelerInfo;
    }
    /**
     * Set TravelerInfo value
     * @param mixed $travelerInfo
     * @return \StructType\AirReservationType
     */
    public function setTravelerInfo($travelerInfo = null)
    {
        $this->TravelerInfo = $travelerInfo;
        return $this;
    }
    /**
     * Get ArrangerInfo value
     * @return mixed|null
     */
    public function getArrangerInfo()
    {
        return $this->ArrangerInfo;
    }
    /**
     * Set ArrangerInfo value
     * @param mixed $arrangerInfo
     * @return \StructType\AirReservationType
     */
    public function setArrangerInfo($arrangerInfo = null)
    {
        $this->ArrangerInfo = $arrangerInfo;
        return $this;
    }
    /**
     * Get Fulfillment value
     * @return mixed|null
     */
    public function getFulfillment()
    {
        return $this->Fulfillment;
    }
    /**
     * Set Fulfillment value
     * @param mixed $fulfillment
     * @return \StructType\AirReservationType
     */
    public function setFulfillment($fulfillment = null)
    {
        $this->Fulfillment = $fulfillment;
        return $this;
    }
    /**
     * Get Ticketing value
     * @return mixed[]|null
     */
    public function getTicketing()
    {
        return $this->Ticketing;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketing method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketing method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketingForArrayConstraintsFromSetTicketing(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airReservationTypeTicketingItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airReservationTypeTicketingItem) ? get_class($airReservationTypeTicketingItem) : sprintf('%s(%s)', gettype($airReservationTypeTicketingItem), var_export($airReservationTypeTicketingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Ticketing property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Ticketing value
     * @throws \InvalidArgumentException
     * @param mixed[] $ticketing
     * @return \StructType\AirReservationType
     */
    public function setTicketing(array $ticketing = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketingArrayErrorMessage = self::validateTicketingForArrayConstraintsFromSetTicketing($ticketing))) {
            throw new \InvalidArgumentException($ticketingArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($ticketing) && count($ticketing) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($ticketing)), __LINE__);
        }
        $this->Ticketing = $ticketing;
        return $this;
    }
    /**
     * Add item to Ticketing value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirReservationType
     */
    public function addToTicketing($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Ticketing property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Ticketing) && count($this->Ticketing) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Ticketing)), __LINE__);
        }
        $this->Ticketing[] = $item;
        return $this;
    }
    /**
     * Get Queues value
     * @return \StructType\Queues|null
     */
    public function getQueues()
    {
        return $this->Queues;
    }
    /**
     * Set Queues value
     * @param \StructType\Queues $queues
     * @return \StructType\AirReservationType
     */
    public function setQueues(\StructType\Queues $queues = null)
    {
        $this->Queues = $queues;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return \StructType\BookingReferenceID[]|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingReferenceID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingReferenceID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingReferenceIDForArrayConstraintsFromSetBookingReferenceID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airReservationTypeBookingReferenceIDItem) {
            // validation for constraint: itemType
            if (!$airReservationTypeBookingReferenceIDItem instanceof \StructType\BookingReferenceID) {
                $invalidValues[] = is_object($airReservationTypeBookingReferenceIDItem) ? get_class($airReservationTypeBookingReferenceIDItem) : sprintf('%s(%s)', gettype($airReservationTypeBookingReferenceIDItem), var_export($airReservationTypeBookingReferenceIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingReferenceID property can only contain items of type \StructType\BookingReferenceID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingReferenceID[] $bookingReferenceID
     * @return \StructType\AirReservationType
     */
    public function setBookingReferenceID(array $bookingReferenceID = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingReferenceIDArrayErrorMessage = self::validateBookingReferenceIDForArrayConstraintsFromSetBookingReferenceID($bookingReferenceID))) {
            throw new \InvalidArgumentException($bookingReferenceIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($bookingReferenceID) && count($bookingReferenceID) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($bookingReferenceID)), __LINE__);
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Add item to BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingReferenceID $item
     * @return \StructType\AirReservationType
     */
    public function addToBookingReferenceID(\StructType\BookingReferenceID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingReferenceID) {
            throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of type \StructType\BookingReferenceID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->BookingReferenceID) && count($this->BookingReferenceID) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->BookingReferenceID)), __LINE__);
        }
        $this->BookingReferenceID[] = $item;
        return $this;
    }
    /**
     * Get Comment value
     * @return mixed|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param mixed $comment
     * @return \StructType\AirReservationType
     */
    public function setComment($comment = null)
    {
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get PricingOverview value
     * @return \StructType\PricingOverview|null
     */
    public function getPricingOverview()
    {
        return $this->PricingOverview;
    }
    /**
     * Set PricingOverview value
     * @param \StructType\PricingOverview $pricingOverview
     * @return \StructType\AirReservationType
     */
    public function setPricingOverview(\StructType\PricingOverview $pricingOverview = null)
    {
        $this->PricingOverview = $pricingOverview;
        return $this;
    }
    /**
     * Get EMD_Info value
     * @return mixed[]|null
     */
    public function getEMD_Info()
    {
        return $this->EMD_Info;
    }
    /**
     * This method is responsible for validating the values passed to the setEMD_Info method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEMD_Info method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEMD_InfoForArrayConstraintsFromSetEMD_Info(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airReservationTypeEMD_InfoItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airReservationTypeEMD_InfoItem) ? get_class($airReservationTypeEMD_InfoItem) : sprintf('%s(%s)', gettype($airReservationTypeEMD_InfoItem), var_export($airReservationTypeEMD_InfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EMD_Info property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EMD_Info value
     * @throws \InvalidArgumentException
     * @param mixed[] $eMD_Info
     * @return \StructType\AirReservationType
     */
    public function setEMD_Info(array $eMD_Info = array())
    {
        // validation for constraint: array
        if ('' !== ($eMD_InfoArrayErrorMessage = self::validateEMD_InfoForArrayConstraintsFromSetEMD_Info($eMD_Info))) {
            throw new \InvalidArgumentException($eMD_InfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($eMD_Info) && count($eMD_Info) > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 999', count($eMD_Info)), __LINE__);
        }
        $this->EMD_Info = $eMD_Info;
        return $this;
    }
    /**
     * Add item to EMD_Info value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirReservationType
     */
    public function addToEMD_Info($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The EMD_Info property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($this->EMD_Info) && count($this->EMD_Info) >= 999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 999', count($this->EMD_Info)), __LINE__);
        }
        $this->EMD_Info[] = $item;
        return $this;
    }
    /**
     * Get LastModified value
     * @return string|null
     */
    public function getLastModified()
    {
        return $this->LastModified;
    }
    /**
     * Set LastModified value
     * @param string $lastModified
     * @return \StructType\AirReservationType
     */
    public function setLastModified($lastModified = null)
    {
        // validation for constraint: string
        if (!is_null($lastModified) && !is_string($lastModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModified, true), gettype($lastModified)), __LINE__);
        }
        $this->LastModified = $lastModified;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirReservationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
