<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirReservation StructType
 * Meta information extracted from the WSDL
 * - documentation: One line in a list of airline reservations.
 * @subpackage Structs
 */
class AirReservation extends AbstractStructBase
{
    /**
     * The FlightSegment
     * Meta information extracted from the WSDL
     * - documentation: The airline code, flight number, departure and arrival dates, and the origin and destination.
     * - minOccurs: 0
     * @var \StructType\FlightSegmentType
     */
    public $FlightSegment;
    /**
     * The TravelerName
     * Meta information extracted from the WSDL
     * - documentation: The names of travelers (up to five) in the reservation.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\PersonNameType[]
     */
    public $TravelerName;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The BookingReferenceID
     * Meta information extracted from the WSDL
     * - documentation: The reservation id number, PNR locator.
     * - use: optional
     * @var string
     */
    public $BookingReferenceID;
    /**
     * The DateBooked
     * Meta information extracted from the WSDL
     * - documentation: Date of the creation of this reservation.
     * - use: optional
     * @var string
     */
    public $DateBooked;
    /**
     * The ItineraryName
     * Meta information extracted from the WSDL
     * - documentation: A name given to this itinerary. | Used for Character Strings, length 0 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 0
     * - use: optional
     * @var string
     */
    public $ItineraryName;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: When true, this booking is cancelled.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The SupplierBookingInfoList
     * Meta information extracted from the WSDL
     * - documentation: Provides additional booking information for the reservation. Refer to OpenTravel Codes List Booking Information List (BIL). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or
     * 101.EQP.X. | List of OpenTravel Codes.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string[]
     */
    public $SupplierBookingInfoList;
    /**
     * Constructor method for AirReservation
     * @uses AirReservation::setFlightSegment()
     * @uses AirReservation::setTravelerName()
     * @uses AirReservation::setTPA_Extensions()
     * @uses AirReservation::setBookingReferenceID()
     * @uses AirReservation::setDateBooked()
     * @uses AirReservation::setItineraryName()
     * @uses AirReservation::setStatus()
     * @uses AirReservation::setSupplierBookingInfoList()
     * @param \StructType\FlightSegmentType $flightSegment
     * @param \StructType\PersonNameType[] $travelerName
     * @param mixed $tPA_Extensions
     * @param string $bookingReferenceID
     * @param string $dateBooked
     * @param string $itineraryName
     * @param string $status
     * @param string[] $supplierBookingInfoList
     */
    public function __construct(\StructType\FlightSegmentType $flightSegment = null, array $travelerName = array(), $tPA_Extensions = null, $bookingReferenceID = null, $dateBooked = null, $itineraryName = null, $status = null, array $supplierBookingInfoList = array())
    {
        $this
            ->setFlightSegment($flightSegment)
            ->setTravelerName($travelerName)
            ->setTPA_Extensions($tPA_Extensions)
            ->setBookingReferenceID($bookingReferenceID)
            ->setDateBooked($dateBooked)
            ->setItineraryName($itineraryName)
            ->setStatus($status)
            ->setSupplierBookingInfoList($supplierBookingInfoList);
    }
    /**
     * Get FlightSegment value
     * @return \StructType\FlightSegmentType|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @param \StructType\FlightSegmentType $flightSegment
     * @return \StructType\AirReservation
     */
    public function setFlightSegment(\StructType\FlightSegmentType $flightSegment = null)
    {
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Get TravelerName value
     * @return \StructType\PersonNameType[]|null
     */
    public function getTravelerName()
    {
        return $this->TravelerName;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelerName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelerName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelerNameForArrayConstraintsFromSetTravelerName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airReservationTravelerNameItem) {
            // validation for constraint: itemType
            if (!$airReservationTravelerNameItem instanceof \StructType\PersonNameType) {
                $invalidValues[] = is_object($airReservationTravelerNameItem) ? get_class($airReservationTravelerNameItem) : sprintf('%s(%s)', gettype($airReservationTravelerNameItem), var_export($airReservationTravelerNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelerName property can only contain items of type \StructType\PersonNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelerName value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonNameType[] $travelerName
     * @return \StructType\AirReservation
     */
    public function setTravelerName(array $travelerName = array())
    {
        // validation for constraint: array
        if ('' !== ($travelerNameArrayErrorMessage = self::validateTravelerNameForArrayConstraintsFromSetTravelerName($travelerName))) {
            throw new \InvalidArgumentException($travelerNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($travelerName) && count($travelerName) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($travelerName)), __LINE__);
        }
        $this->TravelerName = $travelerName;
        return $this;
    }
    /**
     * Add item to TravelerName value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonNameType $item
     * @return \StructType\AirReservation
     */
    public function addToTravelerName(\StructType\PersonNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonNameType) {
            throw new \InvalidArgumentException(sprintf('The TravelerName property can only contain items of type \StructType\PersonNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->TravelerName) && count($this->TravelerName) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->TravelerName)), __LINE__);
        }
        $this->TravelerName[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\AirReservation
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return string|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @param string $bookingReferenceID
     * @return \StructType\AirReservation
     */
    public function setBookingReferenceID($bookingReferenceID = null)
    {
        // validation for constraint: string
        if (!is_null($bookingReferenceID) && !is_string($bookingReferenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingReferenceID, true), gettype($bookingReferenceID)), __LINE__);
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Get DateBooked value
     * @return string|null
     */
    public function getDateBooked()
    {
        return $this->DateBooked;
    }
    /**
     * Set DateBooked value
     * @param string $dateBooked
     * @return \StructType\AirReservation
     */
    public function setDateBooked($dateBooked = null)
    {
        // validation for constraint: string
        if (!is_null($dateBooked) && !is_string($dateBooked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateBooked, true), gettype($dateBooked)), __LINE__);
        }
        $this->DateBooked = $dateBooked;
        return $this;
    }
    /**
     * Get ItineraryName value
     * @return string|null
     */
    public function getItineraryName()
    {
        return $this->ItineraryName;
    }
    /**
     * Set ItineraryName value
     * @param string $itineraryName
     * @return \StructType\AirReservation
     */
    public function setItineraryName($itineraryName = null)
    {
        // validation for constraint: string
        if (!is_null($itineraryName) && !is_string($itineraryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itineraryName, true), gettype($itineraryName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($itineraryName) && mb_strlen($itineraryName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($itineraryName)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($itineraryName) && mb_strlen($itineraryName) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($itineraryName)), __LINE__);
        }
        $this->ItineraryName = $itineraryName;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\TransactionStatusType::valueIsValid()
     * @uses \EnumType\TransactionStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\AirReservation
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionStatusType', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\TransactionStatusType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get SupplierBookingInfoList value
     * @return string[]|null
     */
    public function getSupplierBookingInfoList()
    {
        return $this->SupplierBookingInfoList;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplierBookingInfoList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplierBookingInfoList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplierBookingInfoListForArrayConstraintsFromSetSupplierBookingInfoList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airReservationSupplierBookingInfoListItem) {
            // validation for constraint: itemType
            if (!is_string($airReservationSupplierBookingInfoListItem)) {
                $invalidValues[] = is_object($airReservationSupplierBookingInfoListItem) ? get_class($airReservationSupplierBookingInfoListItem) : sprintf('%s(%s)', gettype($airReservationSupplierBookingInfoListItem), var_export($airReservationSupplierBookingInfoListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SupplierBookingInfoList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SupplierBookingInfoList value
     * @param string[] $supplierBookingInfoList
     * @return \StructType\AirReservation
     */
    public function setSupplierBookingInfoList(array $supplierBookingInfoList = array())
    {
        // validation for constraint: list
        if ('' !== ($supplierBookingInfoListArrayErrorMessage = self::validateSupplierBookingInfoListForArrayConstraintsFromSetSupplierBookingInfoList($supplierBookingInfoList))) {
            throw new \InvalidArgumentException($supplierBookingInfoListArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($supplierBookingInfoList) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $supplierBookingInfoList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($supplierBookingInfoList, true)), __LINE__);
        }
        $this->SupplierBookingInfoList = is_array($supplierBookingInfoList) ? implode(' ', $supplierBookingInfoList) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirReservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
