<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirRedemptionMilesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information about using redemption miles as currency.
 * @subpackage Structs
 */
class AirRedemptionMilesType extends AbstractStructBase
{
    /**
     * The PointQty
     * Meta information extracted from the WSDL
     * - documentation: The number of points (miles) required or used to redeem this award.
     * - use: required
     * @var float
     */
    public $PointQty;
    /**
     * The RewardCode
     * Meta information extracted from the WSDL
     * - documentation: The award code associated with the redemption miles amount.
     * - use: optional
     * @var string
     */
    public $RewardCode;
    /**
     * The MoneyToMilesRatio
     * Meta information extracted from the WSDL
     * - documentation: This attribute assumes the MoneyToMilesRatio:1. For example, a base fare of $100 where MoneyToMilesRatio is 1000 requires 100,000 frequent flyer miles to pay for the full base fare (100 * 1000 = 100,000 miles.) | The ratio used to
     * calculate the number of miles required to pay for any monetary amount.
     * - use: optional
     * @var int
     */
    public $MoneyToMilesRatio;
    /**
     * The DiscountPercentage
     * Meta information extracted from the WSDL
     * - documentation: A percentage used for discount calculations.
     * - use: optional
     * @var float
     */
    public $DiscountPercentage;
    /**
     * Constructor method for AirRedemptionMilesType
     * @uses AirRedemptionMilesType::setPointQty()
     * @uses AirRedemptionMilesType::setRewardCode()
     * @uses AirRedemptionMilesType::setMoneyToMilesRatio()
     * @uses AirRedemptionMilesType::setDiscountPercentage()
     * @param float $pointQty
     * @param string $rewardCode
     * @param int $moneyToMilesRatio
     * @param float $discountPercentage
     */
    public function __construct($pointQty = null, $rewardCode = null, $moneyToMilesRatio = null, $discountPercentage = null)
    {
        $this
            ->setPointQty($pointQty)
            ->setRewardCode($rewardCode)
            ->setMoneyToMilesRatio($moneyToMilesRatio)
            ->setDiscountPercentage($discountPercentage);
    }
    /**
     * Get PointQty value
     * @return float
     */
    public function getPointQty()
    {
        return $this->PointQty;
    }
    /**
     * Set PointQty value
     * @param float $pointQty
     * @return \StructType\AirRedemptionMilesType
     */
    public function setPointQty($pointQty = null)
    {
        // validation for constraint: float
        if (!is_null($pointQty) && !(is_float($pointQty) || is_numeric($pointQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pointQty, true), gettype($pointQty)), __LINE__);
        }
        $this->PointQty = $pointQty;
        return $this;
    }
    /**
     * Get RewardCode value
     * @return string|null
     */
    public function getRewardCode()
    {
        return $this->RewardCode;
    }
    /**
     * Set RewardCode value
     * @param string $rewardCode
     * @return \StructType\AirRedemptionMilesType
     */
    public function setRewardCode($rewardCode = null)
    {
        // validation for constraint: string
        if (!is_null($rewardCode) && !is_string($rewardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rewardCode, true), gettype($rewardCode)), __LINE__);
        }
        $this->RewardCode = $rewardCode;
        return $this;
    }
    /**
     * Get MoneyToMilesRatio value
     * @return int|null
     */
    public function getMoneyToMilesRatio()
    {
        return $this->MoneyToMilesRatio;
    }
    /**
     * Set MoneyToMilesRatio value
     * @param int $moneyToMilesRatio
     * @return \StructType\AirRedemptionMilesType
     */
    public function setMoneyToMilesRatio($moneyToMilesRatio = null)
    {
        // validation for constraint: int
        if (!is_null($moneyToMilesRatio) && !(is_int($moneyToMilesRatio) || ctype_digit($moneyToMilesRatio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($moneyToMilesRatio, true), gettype($moneyToMilesRatio)), __LINE__);
        }
        $this->MoneyToMilesRatio = $moneyToMilesRatio;
        return $this;
    }
    /**
     * Get DiscountPercentage value
     * @return float|null
     */
    public function getDiscountPercentage()
    {
        return $this->DiscountPercentage;
    }
    /**
     * Set DiscountPercentage value
     * @param float $discountPercentage
     * @return \StructType\AirRedemptionMilesType
     */
    public function setDiscountPercentage($discountPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($discountPercentage) && !(is_float($discountPercentage) || is_numeric($discountPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountPercentage, true), gettype($discountPercentage)), __LINE__);
        }
        $this->DiscountPercentage = $discountPercentage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirRedemptionMilesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
