<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirPurchasedOfferType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains an array of ancillary items being or previously purchased for this trip. Internal airline and ATPCO encoding for airline delivered ancillary items and third party trip insurance are supported.
 * @subpackage Structs
 */
class AirPurchasedOfferType extends AbstractStructBase
{
    /**
     * The PurchasedItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\PurchasedItem[]
     */
    public $PurchasedItem;
    /**
     * Constructor method for AirPurchasedOfferType
     * @uses AirPurchasedOfferType::setPurchasedItem()
     * @param \StructType\PurchasedItem[] $purchasedItem
     */
    public function __construct(array $purchasedItem = array())
    {
        $this
            ->setPurchasedItem($purchasedItem);
    }
    /**
     * Get PurchasedItem value
     * @return \StructType\PurchasedItem[]|null
     */
    public function getPurchasedItem()
    {
        return $this->PurchasedItem;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchasedItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchasedItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchasedItemForArrayConstraintsFromSetPurchasedItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airPurchasedOfferTypePurchasedItemItem) {
            // validation for constraint: itemType
            if (!$airPurchasedOfferTypePurchasedItemItem instanceof \StructType\PurchasedItem) {
                $invalidValues[] = is_object($airPurchasedOfferTypePurchasedItemItem) ? get_class($airPurchasedOfferTypePurchasedItemItem) : sprintf('%s(%s)', gettype($airPurchasedOfferTypePurchasedItemItem), var_export($airPurchasedOfferTypePurchasedItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PurchasedItem property can only contain items of type \StructType\PurchasedItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PurchasedItem value
     * @throws \InvalidArgumentException
     * @param \StructType\PurchasedItem[] $purchasedItem
     * @return \StructType\AirPurchasedOfferType
     */
    public function setPurchasedItem(array $purchasedItem = array())
    {
        // validation for constraint: array
        if ('' !== ($purchasedItemArrayErrorMessage = self::validatePurchasedItemForArrayConstraintsFromSetPurchasedItem($purchasedItem))) {
            throw new \InvalidArgumentException($purchasedItemArrayErrorMessage, __LINE__);
        }
        $this->PurchasedItem = $purchasedItem;
        return $this;
    }
    /**
     * Add item to PurchasedItem value
     * @throws \InvalidArgumentException
     * @param \StructType\PurchasedItem $item
     * @return \StructType\AirPurchasedOfferType
     */
    public function addToPurchasedItem(\StructType\PurchasedItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PurchasedItem) {
            throw new \InvalidArgumentException(sprintf('The PurchasedItem property can only contain items of type \StructType\PurchasedItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PurchasedItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirPurchasedOfferType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
