<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirPricingQualifierType StructType
 * Meta information extracted from the WSDL
 * - documentation: Additional pricing information, including negotiated fares, restrictions, promotions and tax exemptions.
 * @subpackage Structs
 */
class AirPricingQualifierType extends AbstractStructBase
{
    /**
     * The AccountCode
     * Meta information extracted from the WSDL
     * - documentation: A code to uniquely identify a fare account.
     * - minOccurs: 0
     * @var string
     */
    public $AccountCode;
    /**
     * The Restrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Restrictions
     */
    public $Restrictions;
    /**
     * The TaxExemption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxExemption
     */
    public $TaxExemption;
    /**
     * The PromotionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PromotionCode
     */
    public $PromotionCode;
    /**
     * The AgeQualifyingCode
     * Meta information extracted from the WSDL
     * - documentation: (Reference) http://www.opentraveldevelopersnetwork.com/Public_OpenTravel_Code_List.php | The age qualifying code of the traveler. Use an item from the OpenTravel Age Qualifying Code (AQC) code list.
     * - use: optional
     * @var string
     */
    public $AgeQualifyingCode;
    /**
     * The InputTicketDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies a fare related designator.
     * - use: optional
     * @var string
     */
    public $InputTicketDesigCode;
    /**
     * Constructor method for AirPricingQualifierType
     * @uses AirPricingQualifierType::setAccountCode()
     * @uses AirPricingQualifierType::setRestrictions()
     * @uses AirPricingQualifierType::setTaxExemption()
     * @uses AirPricingQualifierType::setPromotionCode()
     * @uses AirPricingQualifierType::setAgeQualifyingCode()
     * @uses AirPricingQualifierType::setInputTicketDesigCode()
     * @param string $accountCode
     * @param \StructType\Restrictions $restrictions
     * @param \StructType\TaxExemption $taxExemption
     * @param \StructType\PromotionCode $promotionCode
     * @param string $ageQualifyingCode
     * @param string $inputTicketDesigCode
     */
    public function __construct($accountCode = null, \StructType\Restrictions $restrictions = null, \StructType\TaxExemption $taxExemption = null, \StructType\PromotionCode $promotionCode = null, $ageQualifyingCode = null, $inputTicketDesigCode = null)
    {
        $this
            ->setAccountCode($accountCode)
            ->setRestrictions($restrictions)
            ->setTaxExemption($taxExemption)
            ->setPromotionCode($promotionCode)
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setInputTicketDesigCode($inputTicketDesigCode);
    }
    /**
     * Get AccountCode value
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param string $accountCode
     * @return \StructType\AirPricingQualifierType
     */
    public function setAccountCode($accountCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountCode) && !is_string($accountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountCode, true), gettype($accountCode)), __LINE__);
        }
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Get Restrictions value
     * @return \StructType\Restrictions|null
     */
    public function getRestrictions()
    {
        return $this->Restrictions;
    }
    /**
     * Set Restrictions value
     * @param \StructType\Restrictions $restrictions
     * @return \StructType\AirPricingQualifierType
     */
    public function setRestrictions(\StructType\Restrictions $restrictions = null)
    {
        $this->Restrictions = $restrictions;
        return $this;
    }
    /**
     * Get TaxExemption value
     * @return \StructType\TaxExemption|null
     */
    public function getTaxExemption()
    {
        return $this->TaxExemption;
    }
    /**
     * Set TaxExemption value
     * @param \StructType\TaxExemption $taxExemption
     * @return \StructType\AirPricingQualifierType
     */
    public function setTaxExemption(\StructType\TaxExemption $taxExemption = null)
    {
        $this->TaxExemption = $taxExemption;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return \StructType\PromotionCode|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param \StructType\PromotionCode $promotionCode
     * @return \StructType\AirPricingQualifierType
     */
    public function setPromotionCode(\StructType\PromotionCode $promotionCode = null)
    {
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get AgeQualifyingCode value
     * @return string|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param string $ageQualifyingCode
     * @return \StructType\AirPricingQualifierType
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: string
        if (!is_null($ageQualifyingCode) && !is_string($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageQualifyingCode, true), gettype($ageQualifyingCode)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get InputTicketDesigCode value
     * @return string|null
     */
    public function getInputTicketDesigCode()
    {
        return $this->InputTicketDesigCode;
    }
    /**
     * Set InputTicketDesigCode value
     * @param string $inputTicketDesigCode
     * @return \StructType\AirPricingQualifierType
     */
    public function setInputTicketDesigCode($inputTicketDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($inputTicketDesigCode) && !is_string($inputTicketDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inputTicketDesigCode, true), gettype($inputTicketDesigCode)), __LINE__);
        }
        $this->InputTicketDesigCode = $inputTicketDesigCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirPricingQualifierType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
