<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirPricedOfferType StructType
 * Meta information extracted from the WSDL
 * - documentation: Priced ancillary offer information.
 * @subpackage Structs
 */
class AirPricedOfferType extends AbstractStructBase
{
    /**
     * The ServiceFamily
     * Meta information extracted from the WSDL
     * - documentation: Airline or ATPCO encoded service family(s).
     * @var mixed
     */
    public $ServiceFamily;
    /**
     * The ShortDescription
     * Meta information extracted from the WSDL
     * - documentation: A detailed description of the ancillary item.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $ShortDescription;
    /**
     * The LongDescription
     * Meta information extracted from the WSDL
     * - documentation: A detailed description of the ancillary item.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $LongDescription;
    /**
     * The Pricing
     * @var \StructType\Pricing
     */
    public $Pricing;
    /**
     * The OriginDestination
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\OriginDestination[]
     */
    public $OriginDestination;
    /**
     * The SeatInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SeatInfo
     */
    public $SeatInfo;
    /**
     * The OtherServices
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\OtherServices[]
     */
    public $OtherServices;
    /**
     * The TripInsurance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TripInsurance
     */
    public $TripInsurance;
    /**
     * The BookingInstruction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BookingInstruction
     */
    public $BookingInstruction;
    /**
     * The Restriction
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Restriction[]
     */
    public $Restriction;
    /**
     * The TermsAndConditions
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\TermsAndConditions[]
     */
    public $TermsAndConditions;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: Commission information associated with the offer.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Commission;
    /**
     * The Multimedia
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\Multimedia[]
     */
    public $Multimedia;
    /**
     * The BookingReferenceID
     * Meta information extracted from the WSDL
     * - documentation: The passenger PNR or other booking reference ID.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $BookingReferenceID;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: The unique ID of this priced offer.
     * - use: optional
     * @var string
     */
    public $ID;
    /**
     * The BundleInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this offer is associated with another offer and may not be sold individually.
     * - use: optional
     * @var bool
     */
    public $BundleInd;
    /**
     * The BundleID
     * Meta information extracted from the WSDL
     * - documentation: The unique ID of a priced offer that this offer is associated with.
     * - use: optional
     * @var string
     */
    public $BundleID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the ancillary item.
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The MandatoryInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this is an offer that must be shown to the customer.
     * - use: optional
     * @var bool
     */
    public $MandatoryInd;
    /**
     * The AcceptInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this is an offer that must be accepted by the customer.
     * - use: optional
     * @var bool
     */
    public $AcceptInd;
    /**
     * The TripInsuranceInd
     * Meta information extracted from the WSDL
     * - documentation: If true, trip insurance offers are included.
     * - use: optional
     * @var bool
     */
    public $TripInsuranceInd;
    /**
     * Constructor method for AirPricedOfferType
     * @uses AirPricedOfferType::setServiceFamily()
     * @uses AirPricedOfferType::setShortDescription()
     * @uses AirPricedOfferType::setLongDescription()
     * @uses AirPricedOfferType::setPricing()
     * @uses AirPricedOfferType::setOriginDestination()
     * @uses AirPricedOfferType::setSeatInfo()
     * @uses AirPricedOfferType::setOtherServices()
     * @uses AirPricedOfferType::setTripInsurance()
     * @uses AirPricedOfferType::setBookingInstruction()
     * @uses AirPricedOfferType::setRestriction()
     * @uses AirPricedOfferType::setTermsAndConditions()
     * @uses AirPricedOfferType::setCommission()
     * @uses AirPricedOfferType::setMultimedia()
     * @uses AirPricedOfferType::setBookingReferenceID()
     * @uses AirPricedOfferType::setTPA_Extensions()
     * @uses AirPricedOfferType::setID()
     * @uses AirPricedOfferType::setBundleInd()
     * @uses AirPricedOfferType::setBundleID()
     * @uses AirPricedOfferType::setName()
     * @uses AirPricedOfferType::setMandatoryInd()
     * @uses AirPricedOfferType::setAcceptInd()
     * @uses AirPricedOfferType::setTripInsuranceInd()
     * @param mixed $serviceFamily
     * @param mixed[] $shortDescription
     * @param mixed[] $longDescription
     * @param \StructType\Pricing $pricing
     * @param \StructType\OriginDestination[] $originDestination
     * @param \StructType\SeatInfo $seatInfo
     * @param \StructType\OtherServices[] $otherServices
     * @param \StructType\TripInsurance $tripInsurance
     * @param \StructType\BookingInstruction $bookingInstruction
     * @param \StructType\Restriction[] $restriction
     * @param \StructType\TermsAndConditions[] $termsAndConditions
     * @param mixed[] $commission
     * @param \StructType\Multimedia[] $multimedia
     * @param mixed[] $bookingReferenceID
     * @param mixed $tPA_Extensions
     * @param string $iD
     * @param bool $bundleInd
     * @param string $bundleID
     * @param string $name
     * @param bool $mandatoryInd
     * @param bool $acceptInd
     * @param bool $tripInsuranceInd
     */
    public function __construct($serviceFamily = null, array $shortDescription = array(), array $longDescription = array(), \StructType\Pricing $pricing = null, array $originDestination = array(), \StructType\SeatInfo $seatInfo = null, array $otherServices = array(), \StructType\TripInsurance $tripInsurance = null, \StructType\BookingInstruction $bookingInstruction = null, array $restriction = array(), array $termsAndConditions = array(), array $commission = array(), array $multimedia = array(), array $bookingReferenceID = array(), $tPA_Extensions = null, $iD = null, $bundleInd = null, $bundleID = null, $name = null, $mandatoryInd = null, $acceptInd = null, $tripInsuranceInd = null)
    {
        $this
            ->setServiceFamily($serviceFamily)
            ->setShortDescription($shortDescription)
            ->setLongDescription($longDescription)
            ->setPricing($pricing)
            ->setOriginDestination($originDestination)
            ->setSeatInfo($seatInfo)
            ->setOtherServices($otherServices)
            ->setTripInsurance($tripInsurance)
            ->setBookingInstruction($bookingInstruction)
            ->setRestriction($restriction)
            ->setTermsAndConditions($termsAndConditions)
            ->setCommission($commission)
            ->setMultimedia($multimedia)
            ->setBookingReferenceID($bookingReferenceID)
            ->setTPA_Extensions($tPA_Extensions)
            ->setID($iD)
            ->setBundleInd($bundleInd)
            ->setBundleID($bundleID)
            ->setName($name)
            ->setMandatoryInd($mandatoryInd)
            ->setAcceptInd($acceptInd)
            ->setTripInsuranceInd($tripInsuranceInd);
    }
    /**
     * Get ServiceFamily value
     * @return mixed|null
     */
    public function getServiceFamily()
    {
        return $this->ServiceFamily;
    }
    /**
     * Set ServiceFamily value
     * @param mixed $serviceFamily
     * @return \StructType\AirPricedOfferType
     */
    public function setServiceFamily($serviceFamily = null)
    {
        $this->ServiceFamily = $serviceFamily;
        return $this;
    }
    /**
     * Get ShortDescription value
     * @return mixed[]|null
     */
    public function getShortDescription()
    {
        return $this->ShortDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setShortDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShortDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShortDescriptionForArrayConstraintsFromSetShortDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airPricedOfferTypeShortDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airPricedOfferTypeShortDescriptionItem) ? get_class($airPricedOfferTypeShortDescriptionItem) : sprintf('%s(%s)', gettype($airPricedOfferTypeShortDescriptionItem), var_export($airPricedOfferTypeShortDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShortDescription property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShortDescription value
     * @throws \InvalidArgumentException
     * @param mixed[] $shortDescription
     * @return \StructType\AirPricedOfferType
     */
    public function setShortDescription(array $shortDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($shortDescriptionArrayErrorMessage = self::validateShortDescriptionForArrayConstraintsFromSetShortDescription($shortDescription))) {
            throw new \InvalidArgumentException($shortDescriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($shortDescription) && count($shortDescription) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($shortDescription)), __LINE__);
        }
        $this->ShortDescription = $shortDescription;
        return $this;
    }
    /**
     * Add item to ShortDescription value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirPricedOfferType
     */
    public function addToShortDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The ShortDescription property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->ShortDescription) && count($this->ShortDescription) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->ShortDescription)), __LINE__);
        }
        $this->ShortDescription[] = $item;
        return $this;
    }
    /**
     * Get LongDescription value
     * @return mixed[]|null
     */
    public function getLongDescription()
    {
        return $this->LongDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setLongDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLongDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLongDescriptionForArrayConstraintsFromSetLongDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airPricedOfferTypeLongDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airPricedOfferTypeLongDescriptionItem) ? get_class($airPricedOfferTypeLongDescriptionItem) : sprintf('%s(%s)', gettype($airPricedOfferTypeLongDescriptionItem), var_export($airPricedOfferTypeLongDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LongDescription property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LongDescription value
     * @throws \InvalidArgumentException
     * @param mixed[] $longDescription
     * @return \StructType\AirPricedOfferType
     */
    public function setLongDescription(array $longDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($longDescriptionArrayErrorMessage = self::validateLongDescriptionForArrayConstraintsFromSetLongDescription($longDescription))) {
            throw new \InvalidArgumentException($longDescriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($longDescription) && count($longDescription) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($longDescription)), __LINE__);
        }
        $this->LongDescription = $longDescription;
        return $this;
    }
    /**
     * Add item to LongDescription value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirPricedOfferType
     */
    public function addToLongDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The LongDescription property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->LongDescription) && count($this->LongDescription) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->LongDescription)), __LINE__);
        }
        $this->LongDescription[] = $item;
        return $this;
    }
    /**
     * Get Pricing value
     * @return \StructType\Pricing|null
     */
    public function getPricing()
    {
        return $this->Pricing;
    }
    /**
     * Set Pricing value
     * @param \StructType\Pricing $pricing
     * @return \StructType\AirPricedOfferType
     */
    public function setPricing(\StructType\Pricing $pricing = null)
    {
        $this->Pricing = $pricing;
        return $this;
    }
    /**
     * Get OriginDestination value
     * @return \StructType\OriginDestination[]|null
     */
    public function getOriginDestination()
    {
        return $this->OriginDestination;
    }
    /**
     * This method is responsible for validating the values passed to the setOriginDestination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOriginDestination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOriginDestinationForArrayConstraintsFromSetOriginDestination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airPricedOfferTypeOriginDestinationItem) {
            // validation for constraint: itemType
            if (!$airPricedOfferTypeOriginDestinationItem instanceof \StructType\OriginDestination) {
                $invalidValues[] = is_object($airPricedOfferTypeOriginDestinationItem) ? get_class($airPricedOfferTypeOriginDestinationItem) : sprintf('%s(%s)', gettype($airPricedOfferTypeOriginDestinationItem), var_export($airPricedOfferTypeOriginDestinationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OriginDestination property can only contain items of type \StructType\OriginDestination, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OriginDestination value
     * @throws \InvalidArgumentException
     * @param \StructType\OriginDestination[] $originDestination
     * @return \StructType\AirPricedOfferType
     */
    public function setOriginDestination(array $originDestination = array())
    {
        // validation for constraint: array
        if ('' !== ($originDestinationArrayErrorMessage = self::validateOriginDestinationForArrayConstraintsFromSetOriginDestination($originDestination))) {
            throw new \InvalidArgumentException($originDestinationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($originDestination) && count($originDestination) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($originDestination)), __LINE__);
        }
        $this->OriginDestination = $originDestination;
        return $this;
    }
    /**
     * Add item to OriginDestination value
     * @throws \InvalidArgumentException
     * @param \StructType\OriginDestination $item
     * @return \StructType\AirPricedOfferType
     */
    public function addToOriginDestination(\StructType\OriginDestination $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OriginDestination) {
            throw new \InvalidArgumentException(sprintf('The OriginDestination property can only contain items of type \StructType\OriginDestination, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->OriginDestination) && count($this->OriginDestination) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->OriginDestination)), __LINE__);
        }
        $this->OriginDestination[] = $item;
        return $this;
    }
    /**
     * Get SeatInfo value
     * @return \StructType\SeatInfo|null
     */
    public function getSeatInfo()
    {
        return $this->SeatInfo;
    }
    /**
     * Set SeatInfo value
     * @param \StructType\SeatInfo $seatInfo
     * @return \StructType\AirPricedOfferType
     */
    public function setSeatInfo(\StructType\SeatInfo $seatInfo = null)
    {
        $this->SeatInfo = $seatInfo;
        return $this;
    }
    /**
     * Get OtherServices value
     * @return \StructType\OtherServices[]|null
     */
    public function getOtherServices()
    {
        return $this->OtherServices;
    }
    /**
     * This method is responsible for validating the values passed to the setOtherServices method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOtherServices method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOtherServicesForArrayConstraintsFromSetOtherServices(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airPricedOfferTypeOtherServicesItem) {
            // validation for constraint: itemType
            if (!$airPricedOfferTypeOtherServicesItem instanceof \StructType\OtherServices) {
                $invalidValues[] = is_object($airPricedOfferTypeOtherServicesItem) ? get_class($airPricedOfferTypeOtherServicesItem) : sprintf('%s(%s)', gettype($airPricedOfferTypeOtherServicesItem), var_export($airPricedOfferTypeOtherServicesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OtherServices property can only contain items of type \StructType\OtherServices, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OtherServices value
     * @throws \InvalidArgumentException
     * @param \StructType\OtherServices[] $otherServices
     * @return \StructType\AirPricedOfferType
     */
    public function setOtherServices(array $otherServices = array())
    {
        // validation for constraint: array
        if ('' !== ($otherServicesArrayErrorMessage = self::validateOtherServicesForArrayConstraintsFromSetOtherServices($otherServices))) {
            throw new \InvalidArgumentException($otherServicesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($otherServices) && count($otherServices) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($otherServices)), __LINE__);
        }
        $this->OtherServices = $otherServices;
        return $this;
    }
    /**
     * Add item to OtherServices value
     * @throws \InvalidArgumentException
     * @param \StructType\OtherServices $item
     * @return \StructType\AirPricedOfferType
     */
    public function addToOtherServices(\StructType\OtherServices $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OtherServices) {
            throw new \InvalidArgumentException(sprintf('The OtherServices property can only contain items of type \StructType\OtherServices, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->OtherServices) && count($this->OtherServices) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->OtherServices)), __LINE__);
        }
        $this->OtherServices[] = $item;
        return $this;
    }
    /**
     * Get TripInsurance value
     * @return \StructType\TripInsurance|null
     */
    public function getTripInsurance()
    {
        return $this->TripInsurance;
    }
    /**
     * Set TripInsurance value
     * @param \StructType\TripInsurance $tripInsurance
     * @return \StructType\AirPricedOfferType
     */
    public function setTripInsurance(\StructType\TripInsurance $tripInsurance = null)
    {
        $this->TripInsurance = $tripInsurance;
        return $this;
    }
    /**
     * Get BookingInstruction value
     * @return \StructType\BookingInstruction|null
     */
    public function getBookingInstruction()
    {
        return $this->BookingInstruction;
    }
    /**
     * Set BookingInstruction value
     * @param \StructType\BookingInstruction $bookingInstruction
     * @return \StructType\AirPricedOfferType
     */
    public function setBookingInstruction(\StructType\BookingInstruction $bookingInstruction = null)
    {
        $this->BookingInstruction = $bookingInstruction;
        return $this;
    }
    /**
     * Get Restriction value
     * @return \StructType\Restriction[]|null
     */
    public function getRestriction()
    {
        return $this->Restriction;
    }
    /**
     * This method is responsible for validating the values passed to the setRestriction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestriction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestrictionForArrayConstraintsFromSetRestriction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airPricedOfferTypeRestrictionItem) {
            // validation for constraint: itemType
            if (!$airPricedOfferTypeRestrictionItem instanceof \StructType\Restriction) {
                $invalidValues[] = is_object($airPricedOfferTypeRestrictionItem) ? get_class($airPricedOfferTypeRestrictionItem) : sprintf('%s(%s)', gettype($airPricedOfferTypeRestrictionItem), var_export($airPricedOfferTypeRestrictionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restriction property can only contain items of type \StructType\Restriction, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restriction value
     * @throws \InvalidArgumentException
     * @param \StructType\Restriction[] $restriction
     * @return \StructType\AirPricedOfferType
     */
    public function setRestriction(array $restriction = array())
    {
        // validation for constraint: array
        if ('' !== ($restrictionArrayErrorMessage = self::validateRestrictionForArrayConstraintsFromSetRestriction($restriction))) {
            throw new \InvalidArgumentException($restrictionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($restriction) && count($restriction) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($restriction)), __LINE__);
        }
        $this->Restriction = $restriction;
        return $this;
    }
    /**
     * Add item to Restriction value
     * @throws \InvalidArgumentException
     * @param \StructType\Restriction $item
     * @return \StructType\AirPricedOfferType
     */
    public function addToRestriction(\StructType\Restriction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Restriction) {
            throw new \InvalidArgumentException(sprintf('The Restriction property can only contain items of type \StructType\Restriction, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Restriction) && count($this->Restriction) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Restriction)), __LINE__);
        }
        $this->Restriction[] = $item;
        return $this;
    }
    /**
     * Get TermsAndConditions value
     * @return \StructType\TermsAndConditions[]|null
     */
    public function getTermsAndConditions()
    {
        return $this->TermsAndConditions;
    }
    /**
     * This method is responsible for validating the values passed to the setTermsAndConditions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTermsAndConditions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTermsAndConditionsForArrayConstraintsFromSetTermsAndConditions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airPricedOfferTypeTermsAndConditionsItem) {
            // validation for constraint: itemType
            if (!$airPricedOfferTypeTermsAndConditionsItem instanceof \StructType\TermsAndConditions) {
                $invalidValues[] = is_object($airPricedOfferTypeTermsAndConditionsItem) ? get_class($airPricedOfferTypeTermsAndConditionsItem) : sprintf('%s(%s)', gettype($airPricedOfferTypeTermsAndConditionsItem), var_export($airPricedOfferTypeTermsAndConditionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TermsAndConditions property can only contain items of type \StructType\TermsAndConditions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TermsAndConditions value
     * @throws \InvalidArgumentException
     * @param \StructType\TermsAndConditions[] $termsAndConditions
     * @return \StructType\AirPricedOfferType
     */
    public function setTermsAndConditions(array $termsAndConditions = array())
    {
        // validation for constraint: array
        if ('' !== ($termsAndConditionsArrayErrorMessage = self::validateTermsAndConditionsForArrayConstraintsFromSetTermsAndConditions($termsAndConditions))) {
            throw new \InvalidArgumentException($termsAndConditionsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($termsAndConditions) && count($termsAndConditions) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($termsAndConditions)), __LINE__);
        }
        $this->TermsAndConditions = $termsAndConditions;
        return $this;
    }
    /**
     * Add item to TermsAndConditions value
     * @throws \InvalidArgumentException
     * @param \StructType\TermsAndConditions $item
     * @return \StructType\AirPricedOfferType
     */
    public function addToTermsAndConditions(\StructType\TermsAndConditions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TermsAndConditions) {
            throw new \InvalidArgumentException(sprintf('The TermsAndConditions property can only contain items of type \StructType\TermsAndConditions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->TermsAndConditions) && count($this->TermsAndConditions) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->TermsAndConditions)), __LINE__);
        }
        $this->TermsAndConditions[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return mixed[]|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * This method is responsible for validating the values passed to the setCommission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommission method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionForArrayConstraintsFromSetCommission(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airPricedOfferTypeCommissionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airPricedOfferTypeCommissionItem) ? get_class($airPricedOfferTypeCommissionItem) : sprintf('%s(%s)', gettype($airPricedOfferTypeCommissionItem), var_export($airPricedOfferTypeCommissionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commission property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commission value
     * @throws \InvalidArgumentException
     * @param mixed[] $commission
     * @return \StructType\AirPricedOfferType
     */
    public function setCommission(array $commission = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionArrayErrorMessage = self::validateCommissionForArrayConstraintsFromSetCommission($commission))) {
            throw new \InvalidArgumentException($commissionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($commission) && count($commission) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($commission)), __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Add item to Commission value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirPricedOfferType
     */
    public function addToCommission($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Commission property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->Commission) && count($this->Commission) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->Commission)), __LINE__);
        }
        $this->Commission[] = $item;
        return $this;
    }
    /**
     * Get Multimedia value
     * @return \StructType\Multimedia[]|null
     */
    public function getMultimedia()
    {
        return $this->Multimedia;
    }
    /**
     * This method is responsible for validating the values passed to the setMultimedia method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultimedia method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMultimediaForArrayConstraintsFromSetMultimedia(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airPricedOfferTypeMultimediaItem) {
            // validation for constraint: itemType
            if (!$airPricedOfferTypeMultimediaItem instanceof \StructType\Multimedia) {
                $invalidValues[] = is_object($airPricedOfferTypeMultimediaItem) ? get_class($airPricedOfferTypeMultimediaItem) : sprintf('%s(%s)', gettype($airPricedOfferTypeMultimediaItem), var_export($airPricedOfferTypeMultimediaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Multimedia property can only contain items of type \StructType\Multimedia, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Multimedia value
     * @throws \InvalidArgumentException
     * @param \StructType\Multimedia[] $multimedia
     * @return \StructType\AirPricedOfferType
     */
    public function setMultimedia(array $multimedia = array())
    {
        // validation for constraint: array
        if ('' !== ($multimediaArrayErrorMessage = self::validateMultimediaForArrayConstraintsFromSetMultimedia($multimedia))) {
            throw new \InvalidArgumentException($multimediaArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($multimedia) && count($multimedia) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($multimedia)), __LINE__);
        }
        $this->Multimedia = $multimedia;
        return $this;
    }
    /**
     * Add item to Multimedia value
     * @throws \InvalidArgumentException
     * @param \StructType\Multimedia $item
     * @return \StructType\AirPricedOfferType
     */
    public function addToMultimedia(\StructType\Multimedia $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Multimedia) {
            throw new \InvalidArgumentException(sprintf('The Multimedia property can only contain items of type \StructType\Multimedia, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->Multimedia) && count($this->Multimedia) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->Multimedia)), __LINE__);
        }
        $this->Multimedia[] = $item;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return mixed[]|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingReferenceID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingReferenceID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingReferenceIDForArrayConstraintsFromSetBookingReferenceID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airPricedOfferTypeBookingReferenceIDItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airPricedOfferTypeBookingReferenceIDItem) ? get_class($airPricedOfferTypeBookingReferenceIDItem) : sprintf('%s(%s)', gettype($airPricedOfferTypeBookingReferenceIDItem), var_export($airPricedOfferTypeBookingReferenceIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingReferenceID property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param mixed[] $bookingReferenceID
     * @return \StructType\AirPricedOfferType
     */
    public function setBookingReferenceID(array $bookingReferenceID = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingReferenceIDArrayErrorMessage = self::validateBookingReferenceIDForArrayConstraintsFromSetBookingReferenceID($bookingReferenceID))) {
            throw new \InvalidArgumentException($bookingReferenceIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($bookingReferenceID) && count($bookingReferenceID) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($bookingReferenceID)), __LINE__);
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Add item to BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirPricedOfferType
     */
    public function addToBookingReferenceID($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->BookingReferenceID) && count($this->BookingReferenceID) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->BookingReferenceID)), __LINE__);
        }
        $this->BookingReferenceID[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\AirPricedOfferType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\AirPricedOfferType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get BundleInd value
     * @return bool|null
     */
    public function getBundleInd()
    {
        return $this->BundleInd;
    }
    /**
     * Set BundleInd value
     * @param bool $bundleInd
     * @return \StructType\AirPricedOfferType
     */
    public function setBundleInd($bundleInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($bundleInd) && !is_bool($bundleInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bundleInd, true), gettype($bundleInd)), __LINE__);
        }
        $this->BundleInd = $bundleInd;
        return $this;
    }
    /**
     * Get BundleID value
     * @return string|null
     */
    public function getBundleID()
    {
        return $this->BundleID;
    }
    /**
     * Set BundleID value
     * @param string $bundleID
     * @return \StructType\AirPricedOfferType
     */
    public function setBundleID($bundleID = null)
    {
        // validation for constraint: string
        if (!is_null($bundleID) && !is_string($bundleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleID, true), gettype($bundleID)), __LINE__);
        }
        $this->BundleID = $bundleID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\AirPricedOfferType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get MandatoryInd value
     * @return bool|null
     */
    public function getMandatoryInd()
    {
        return $this->MandatoryInd;
    }
    /**
     * Set MandatoryInd value
     * @param bool $mandatoryInd
     * @return \StructType\AirPricedOfferType
     */
    public function setMandatoryInd($mandatoryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatoryInd) && !is_bool($mandatoryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatoryInd, true), gettype($mandatoryInd)), __LINE__);
        }
        $this->MandatoryInd = $mandatoryInd;
        return $this;
    }
    /**
     * Get AcceptInd value
     * @return bool|null
     */
    public function getAcceptInd()
    {
        return $this->AcceptInd;
    }
    /**
     * Set AcceptInd value
     * @param bool $acceptInd
     * @return \StructType\AirPricedOfferType
     */
    public function setAcceptInd($acceptInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($acceptInd) && !is_bool($acceptInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($acceptInd, true), gettype($acceptInd)), __LINE__);
        }
        $this->AcceptInd = $acceptInd;
        return $this;
    }
    /**
     * Get TripInsuranceInd value
     * @return bool|null
     */
    public function getTripInsuranceInd()
    {
        return $this->TripInsuranceInd;
    }
    /**
     * Set TripInsuranceInd value
     * @param bool $tripInsuranceInd
     * @return \StructType\AirPricedOfferType
     */
    public function setTripInsuranceInd($tripInsuranceInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($tripInsuranceInd) && !is_bool($tripInsuranceInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tripInsuranceInd, true), gettype($tripInsuranceInd)), __LINE__);
        }
        $this->TripInsuranceInd = $tripInsuranceInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirPricedOfferType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
