<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirOfferChoiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: A choice between specifying summary, priced or traveler purchased ancillary offers.
 * @subpackage Structs
 */
class AirOfferChoiceType extends AbstractStructBase
{
    /**
     * The Summary
     * Meta information extracted from the WSDL
     * - choice: Summary | Priced | Purchased
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Summary[]
     */
    public $Summary;
    /**
     * The Priced
     * Meta information extracted from the WSDL
     * - choice: Summary | Priced | Purchased
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Priced[]
     */
    public $Priced;
    /**
     * The Purchased
     * Meta information extracted from the WSDL
     * - documentation: Air offers already purchased for a trip.
     * - choice: Summary | Priced | Purchased
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Purchased;
    /**
     * Constructor method for AirOfferChoiceType
     * @uses AirOfferChoiceType::setSummary()
     * @uses AirOfferChoiceType::setPriced()
     * @uses AirOfferChoiceType::setPurchased()
     * @param \StructType\Summary[] $summary
     * @param \StructType\Priced[] $priced
     * @param mixed[] $purchased
     */
    public function __construct(array $summary = array(), array $priced = array(), array $purchased = array())
    {
        $this
            ->setSummary($summary)
            ->setPriced($priced)
            ->setPurchased($purchased);
    }
    /**
     * Get Summary value
     * @return \StructType\Summary[]|null
     */
    public function getSummary()
    {
        return isset($this->Summary) ? $this->Summary : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSummaryForArrayConstraintsFromSetSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airOfferChoiceTypeSummaryItem) {
            // validation for constraint: itemType
            if (!$airOfferChoiceTypeSummaryItem instanceof \StructType\Summary) {
                $invalidValues[] = is_object($airOfferChoiceTypeSummaryItem) ? get_class($airOfferChoiceTypeSummaryItem) : sprintf('%s(%s)', gettype($airOfferChoiceTypeSummaryItem), var_export($airOfferChoiceTypeSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Summary property can only contain items of type \StructType\Summary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSummary method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSummaryForChoiceConstraintsFromSetSummary($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Priced',
            'Purchased',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Summary can\'t be set as the property %s is already set. Only one property must be set among these properties: Summary, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Summary value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Summary[] $summary
     * @return \StructType\AirOfferChoiceType
     */
    public function setSummary(array $summary = array())
    {
        // validation for constraint: array
        if ('' !== ($summaryArrayErrorMessage = self::validateSummaryForArrayConstraintsFromSetSummary($summary))) {
            throw new \InvalidArgumentException($summaryArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Summary, Priced, Purchased)
        if ('' !== ($summaryChoiceErrorMessage = self::validateSummaryForChoiceConstraintsFromSetSummary($summary))) {
            throw new \InvalidArgumentException($summaryChoiceErrorMessage, __LINE__);
        }
        if (is_null($summary) || (is_array($summary) && empty($summary))) {
            unset($this->Summary);
        } else {
            $this->Summary = $summary;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToSummary method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToSummary($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Priced',
            'Purchased',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Summary can\'t be set as the property %s is already set. Only one property must be set among these properties: Summary, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Summary value
     * @throws \InvalidArgumentException
     * @param \StructType\Summary $item
     * @return \StructType\AirOfferChoiceType
     */
    public function addToSummary(\StructType\Summary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Summary) {
            throw new \InvalidArgumentException(sprintf('The Summary property can only contain items of type \StructType\Summary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Summary, Priced, Purchased)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToSummary($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Summary[] = $item;
        return $this;
    }
    /**
     * Get Priced value
     * @return \StructType\Priced[]|null
     */
    public function getPriced()
    {
        return isset($this->Priced) ? $this->Priced : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPriced method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriced method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricedForArrayConstraintsFromSetPriced(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airOfferChoiceTypePricedItem) {
            // validation for constraint: itemType
            if (!$airOfferChoiceTypePricedItem instanceof \StructType\Priced) {
                $invalidValues[] = is_object($airOfferChoiceTypePricedItem) ? get_class($airOfferChoiceTypePricedItem) : sprintf('%s(%s)', gettype($airOfferChoiceTypePricedItem), var_export($airOfferChoiceTypePricedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Priced property can only contain items of type \StructType\Priced, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setPriced method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriced method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePricedForChoiceConstraintsFromSetPriced($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Summary',
            'Purchased',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Priced can\'t be set as the property %s is already set. Only one property must be set among these properties: Priced, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Priced value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Priced[] $priced
     * @return \StructType\AirOfferChoiceType
     */
    public function setPriced(array $priced = array())
    {
        // validation for constraint: array
        if ('' !== ($pricedArrayErrorMessage = self::validatePricedForArrayConstraintsFromSetPriced($priced))) {
            throw new \InvalidArgumentException($pricedArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Summary, Priced, Purchased)
        if ('' !== ($pricedChoiceErrorMessage = self::validatePricedForChoiceConstraintsFromSetPriced($priced))) {
            throw new \InvalidArgumentException($pricedChoiceErrorMessage, __LINE__);
        }
        if (is_null($priced) || (is_array($priced) && empty($priced))) {
            unset($this->Priced);
        } else {
            $this->Priced = $priced;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToPriced method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToPriced method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToPriced($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Summary',
            'Purchased',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Priced can\'t be set as the property %s is already set. Only one property must be set among these properties: Priced, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Priced value
     * @throws \InvalidArgumentException
     * @param \StructType\Priced $item
     * @return \StructType\AirOfferChoiceType
     */
    public function addToPriced(\StructType\Priced $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Priced) {
            throw new \InvalidArgumentException(sprintf('The Priced property can only contain items of type \StructType\Priced, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Summary, Priced, Purchased)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToPriced($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Priced[] = $item;
        return $this;
    }
    /**
     * Get Purchased value
     * @return mixed[]|null
     */
    public function getPurchased()
    {
        return isset($this->Purchased) ? $this->Purchased : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchased method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchased method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchasedForArrayConstraintsFromSetPurchased(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airOfferChoiceTypePurchasedItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airOfferChoiceTypePurchasedItem) ? get_class($airOfferChoiceTypePurchasedItem) : sprintf('%s(%s)', gettype($airOfferChoiceTypePurchasedItem), var_export($airOfferChoiceTypePurchasedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchased property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setPurchased method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchased method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePurchasedForChoiceConstraintsFromSetPurchased($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Summary',
            'Priced',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Purchased can\'t be set as the property %s is already set. Only one property must be set among these properties: Purchased, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Purchased value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param mixed[] $purchased
     * @return \StructType\AirOfferChoiceType
     */
    public function setPurchased(array $purchased = array())
    {
        // validation for constraint: array
        if ('' !== ($purchasedArrayErrorMessage = self::validatePurchasedForArrayConstraintsFromSetPurchased($purchased))) {
            throw new \InvalidArgumentException($purchasedArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Summary, Priced, Purchased)
        if ('' !== ($purchasedChoiceErrorMessage = self::validatePurchasedForChoiceConstraintsFromSetPurchased($purchased))) {
            throw new \InvalidArgumentException($purchasedChoiceErrorMessage, __LINE__);
        }
        if (is_null($purchased) || (is_array($purchased) && empty($purchased))) {
            unset($this->Purchased);
        } else {
            $this->Purchased = $purchased;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToPurchased method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToPurchased method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToPurchased($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Summary',
            'Priced',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Purchased can\'t be set as the property %s is already set. Only one property must be set among these properties: Purchased, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Purchased value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirOfferChoiceType
     */
    public function addToPurchased($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Purchased property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Summary, Priced, Purchased)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToPurchased($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Purchased[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirOfferChoiceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
