<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirLandProductType StructType
 * Meta information extracted from the WSDL
 * - documentation: Location information related to the service. May be used for items that are only valid for one location, such as an airport lounge pass. | Information about a land product(s), such as lounge passes.
 * @subpackage Structs
 */
class AirLandProductType extends AbstractStructBase
{
    /**
     * The ProductSupplier
     * Meta information extracted from the WSDL
     * - documentation: The name of the product supplier.
     * - minOccurs: 0
     * @var mixed
     */
    public $ProductSupplier;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: The supplier location.
     * - minOccurs: 0
     * @var mixed
     */
    public $Address;
    /**
     * The StartDateTime
     * Meta information extracted from the WSDL
     * - documentation: The start date (and optional time) that the product is valid for. This is typically used as an effective date/time for lounge passes and other merchandise.
     * - use: optional
     * @var string
     */
    public $StartDateTime;
    /**
     * The EndDateTime
     * Meta information extracted from the WSDL
     * - documentation: The end date (and optional time) that the product is valid for. This is typically used for an expiration date/time on lounge passes and other merchandise.
     * - use: optional
     * @var string
     */
    public $EndDateTime;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique ID for this land product that may be referenced elsewhere in this message.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for AirLandProductType
     * @uses AirLandProductType::setProductSupplier()
     * @uses AirLandProductType::setAddress()
     * @uses AirLandProductType::setStartDateTime()
     * @uses AirLandProductType::setEndDateTime()
     * @uses AirLandProductType::setRPH()
     * @param mixed $productSupplier
     * @param mixed $address
     * @param string $startDateTime
     * @param string $endDateTime
     * @param string $rPH
     */
    public function __construct($productSupplier = null, $address = null, $startDateTime = null, $endDateTime = null, $rPH = null)
    {
        $this
            ->setProductSupplier($productSupplier)
            ->setAddress($address)
            ->setStartDateTime($startDateTime)
            ->setEndDateTime($endDateTime)
            ->setRPH($rPH);
    }
    /**
     * Get ProductSupplier value
     * @return mixed|null
     */
    public function getProductSupplier()
    {
        return $this->ProductSupplier;
    }
    /**
     * Set ProductSupplier value
     * @param mixed $productSupplier
     * @return \StructType\AirLandProductType
     */
    public function setProductSupplier($productSupplier = null)
    {
        $this->ProductSupplier = $productSupplier;
        return $this;
    }
    /**
     * Get Address value
     * @return mixed|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param mixed $address
     * @return \StructType\AirLandProductType
     */
    public function setAddress($address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get StartDateTime value
     * @return string|null
     */
    public function getStartDateTime()
    {
        return $this->StartDateTime;
    }
    /**
     * Set StartDateTime value
     * @param string $startDateTime
     * @return \StructType\AirLandProductType
     */
    public function setStartDateTime($startDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTime) && !is_string($startDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateTime, true), gettype($startDateTime)), __LINE__);
        }
        $this->StartDateTime = $startDateTime;
        return $this;
    }
    /**
     * Get EndDateTime value
     * @return string|null
     */
    public function getEndDateTime()
    {
        return $this->EndDateTime;
    }
    /**
     * Set EndDateTime value
     * @param string $endDateTime
     * @return \StructType\AirLandProductType
     */
    public function setEndDateTime($endDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($endDateTime) && !is_string($endDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDateTime, true), gettype($endDateTime)), __LINE__);
        }
        $this->EndDateTime = $endDateTime;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\AirLandProductType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirLandProductType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
