<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirItineraryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the origin and destination of the traveler.
 * @subpackage Structs
 */
class AirItineraryType extends AbstractStructBase
{
    /**
     * The OriginDestinationOptions
     * @var \StructType\OriginDestinationOptions
     */
    public $OriginDestinationOptions;
    /**
     * The DirectionInd
     * Meta information extracted from the WSDL
     * - documentation: Identifies whether travel is: one way, return trip, circle trip, open jaw, other.
     * - use: optional
     * @var string
     */
    public $DirectionInd;
    /**
     * The AirItineraryRPH
     * Meta information extracted from the WSDL
     * - documentation: Air itinerary unique ID.
     * - use: optional
     * @var string
     */
    public $AirItineraryRPH;
    /**
     * Constructor method for AirItineraryType
     * @uses AirItineraryType::setOriginDestinationOptions()
     * @uses AirItineraryType::setDirectionInd()
     * @uses AirItineraryType::setAirItineraryRPH()
     * @param \StructType\OriginDestinationOptions $originDestinationOptions
     * @param string $directionInd
     * @param string $airItineraryRPH
     */
    public function __construct(\StructType\OriginDestinationOptions $originDestinationOptions = null, $directionInd = null, $airItineraryRPH = null)
    {
        $this
            ->setOriginDestinationOptions($originDestinationOptions)
            ->setDirectionInd($directionInd)
            ->setAirItineraryRPH($airItineraryRPH);
    }
    /**
     * Get OriginDestinationOptions value
     * @return \StructType\OriginDestinationOptions|null
     */
    public function getOriginDestinationOptions()
    {
        return $this->OriginDestinationOptions;
    }
    /**
     * Set OriginDestinationOptions value
     * @param \StructType\OriginDestinationOptions $originDestinationOptions
     * @return \StructType\AirItineraryType
     */
    public function setOriginDestinationOptions(\StructType\OriginDestinationOptions $originDestinationOptions = null)
    {
        $this->OriginDestinationOptions = $originDestinationOptions;
        return $this;
    }
    /**
     * Get DirectionInd value
     * @return string|null
     */
    public function getDirectionInd()
    {
        return $this->DirectionInd;
    }
    /**
     * Set DirectionInd value
     * @uses \EnumType\AirTripType::valueIsValid()
     * @uses \EnumType\AirTripType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $directionInd
     * @return \StructType\AirItineraryType
     */
    public function setDirectionInd($directionInd = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirTripType::valueIsValid($directionInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AirTripType', is_array($directionInd) ? implode(', ', $directionInd) : var_export($directionInd, true), implode(', ', \EnumType\AirTripType::getValidValues())), __LINE__);
        }
        $this->DirectionInd = $directionInd;
        return $this;
    }
    /**
     * Get AirItineraryRPH value
     * @return string|null
     */
    public function getAirItineraryRPH()
    {
        return $this->AirItineraryRPH;
    }
    /**
     * Set AirItineraryRPH value
     * @param string $airItineraryRPH
     * @return \StructType\AirItineraryType
     */
    public function setAirItineraryRPH($airItineraryRPH = null)
    {
        // validation for constraint: string
        if (!is_null($airItineraryRPH) && !is_string($airItineraryRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airItineraryRPH, true), gettype($airItineraryRPH)), __LINE__);
        }
        $this->AirItineraryRPH = $airItineraryRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirItineraryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
