<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirFeeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines a fee in terms of its amount, currency and decimal places. | Provides a monetary amount and the currency code to reflect the currency in which this amount is expressed. | Defines the data fields available for the fees. | A
 * textual description.
 * - base: xs:string
 * - maxLength: 64
 * - minLength: 0
 * @subpackage Structs
 */
class AirFeeType extends AbstractStructBase
{
    /**
     * The FeeCode
     * Meta information extracted from the WSDL
     * - documentation: Identifies the code for the fee.
     * - use: required
     * @var string
     */
    public $FeeCode;
    /**
     * The TaxPercentage
     * Meta information extracted from the WSDL
     * - documentation: Indicates the tax percentage included in this fee (e.g., the Value Added Tax (VAT) percentage).
     * - use: optional
     * @var float
     */
    public $TaxPercentage;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * The FeeTransactionType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FeeTransactionType;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique reference for the fee type (commonly used for modification.)
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for AirFeeType
     * @uses AirFeeType::setFeeCode()
     * @uses AirFeeType::setTaxPercentage()
     * @uses AirFeeType::setOperation()
     * @uses AirFeeType::setFeeTransactionType()
     * @uses AirFeeType::setRPH()
     * @param string $feeCode
     * @param float $taxPercentage
     * @param string $operation
     * @param string $feeTransactionType
     * @param string $rPH
     */
    public function __construct($feeCode = null, $taxPercentage = null, $operation = null, $feeTransactionType = null, $rPH = null)
    {
        $this
            ->setFeeCode($feeCode)
            ->setTaxPercentage($taxPercentage)
            ->setOperation($operation)
            ->setFeeTransactionType($feeTransactionType)
            ->setRPH($rPH);
    }
    /**
     * Get FeeCode value
     * @return string
     */
    public function getFeeCode()
    {
        return $this->FeeCode;
    }
    /**
     * Set FeeCode value
     * @param string $feeCode
     * @return \StructType\AirFeeType
     */
    public function setFeeCode($feeCode = null)
    {
        // validation for constraint: string
        if (!is_null($feeCode) && !is_string($feeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeCode, true), gettype($feeCode)), __LINE__);
        }
        $this->FeeCode = $feeCode;
        return $this;
    }
    /**
     * Get TaxPercentage value
     * @return float|null
     */
    public function getTaxPercentage()
    {
        return $this->TaxPercentage;
    }
    /**
     * Set TaxPercentage value
     * @param float $taxPercentage
     * @return \StructType\AirFeeType
     */
    public function setTaxPercentage($taxPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($taxPercentage) && !(is_float($taxPercentage) || is_numeric($taxPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxPercentage, true), gettype($taxPercentage)), __LINE__);
        }
        $this->TaxPercentage = $taxPercentage;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\AirFeeType
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get FeeTransactionType value
     * @return string|null
     */
    public function getFeeTransactionType()
    {
        return $this->FeeTransactionType;
    }
    /**
     * Set FeeTransactionType value
     * @param string $feeTransactionType
     * @return \StructType\AirFeeType
     */
    public function setFeeTransactionType($feeTransactionType = null)
    {
        // validation for constraint: string
        if (!is_null($feeTransactionType) && !is_string($feeTransactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeTransactionType, true), gettype($feeTransactionType)), __LINE__);
        }
        $this->FeeTransactionType = $feeTransactionType;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\AirFeeType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirFeeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
