<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirArrangerType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information about a person or entity associated with an air trip who will not be traveling. This is generally used to describe one or more parties that may be paying for a ticket and/or making the travel plans.
 * @subpackage Structs
 */
class AirArrangerType extends AbstractStructBase
{
    /**
     * The ProfileRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProfileRef
     */
    public $ProfileRef;
    /**
     * The CompanyInfo
     * Meta information extracted from the WSDL
     * - documentation: Name and contact person information for the company associated with the air travel.
     * - minOccurs: 0
     * @var mixed
     */
    public $CompanyInfo;
    /**
     * The ContactName
     * Meta information extracted from the WSDL
     * - documentation: Name information for the person associated with the air travel.
     * - minOccurs: 0
     * @var mixed
     */
    public $ContactName;
    /**
     * The Role
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Role;
    /**
     * The IATA_Number
     * Meta information extracted from the WSDL
     * - documentation: http://www.opentraveldevelopersnetwork.com/Supported_IATA_Standards.php | If travel agency, the agency IATA number.
     * - use: optional
     * @var string
     */
    public $IATA_Number;
    /**
     * Constructor method for AirArrangerType
     * @uses AirArrangerType::setProfileRef()
     * @uses AirArrangerType::setCompanyInfo()
     * @uses AirArrangerType::setContactName()
     * @uses AirArrangerType::setRole()
     * @uses AirArrangerType::setIATA_Number()
     * @param \StructType\ProfileRef $profileRef
     * @param mixed $companyInfo
     * @param mixed $contactName
     * @param string $role
     * @param string $iATA_Number
     */
    public function __construct(\StructType\ProfileRef $profileRef = null, $companyInfo = null, $contactName = null, $role = null, $iATA_Number = null)
    {
        $this
            ->setProfileRef($profileRef)
            ->setCompanyInfo($companyInfo)
            ->setContactName($contactName)
            ->setRole($role)
            ->setIATA_Number($iATA_Number);
    }
    /**
     * Get ProfileRef value
     * @return \StructType\ProfileRef|null
     */
    public function getProfileRef()
    {
        return $this->ProfileRef;
    }
    /**
     * Set ProfileRef value
     * @param \StructType\ProfileRef $profileRef
     * @return \StructType\AirArrangerType
     */
    public function setProfileRef(\StructType\ProfileRef $profileRef = null)
    {
        $this->ProfileRef = $profileRef;
        return $this;
    }
    /**
     * Get CompanyInfo value
     * @return mixed|null
     */
    public function getCompanyInfo()
    {
        return $this->CompanyInfo;
    }
    /**
     * Set CompanyInfo value
     * @param mixed $companyInfo
     * @return \StructType\AirArrangerType
     */
    public function setCompanyInfo($companyInfo = null)
    {
        $this->CompanyInfo = $companyInfo;
        return $this;
    }
    /**
     * Get ContactName value
     * @return mixed|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param mixed $contactName
     * @return \StructType\AirArrangerType
     */
    public function setContactName($contactName = null)
    {
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get Role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->Role;
    }
    /**
     * Set Role value
     * @param string $role
     * @return \StructType\AirArrangerType
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($role, true), gettype($role)), __LINE__);
        }
        $this->Role = $role;
        return $this;
    }
    /**
     * Get IATA_Number value
     * @return string|null
     */
    public function getIATA_Number()
    {
        return $this->IATA_Number;
    }
    /**
     * Set IATA_Number value
     * @param string $iATA_Number
     * @return \StructType\AirArrangerType
     */
    public function setIATA_Number($iATA_Number = null)
    {
        // validation for constraint: string
        if (!is_null($iATA_Number) && !is_string($iATA_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATA_Number, true), gettype($iATA_Number)), __LINE__);
        }
        $this->IATA_Number = $iATA_Number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirArrangerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
