<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirAccommodations StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of air accommodations.
 * @subpackage Structs
 */
class AirAccommodations extends AbstractStructBase
{
    /**
     * The AirAccommodation
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\AirAccommodation[]
     */
    public $AirAccommodation;
    /**
     * Constructor method for AirAccommodations
     * @uses AirAccommodations::setAirAccommodation()
     * @param \StructType\AirAccommodation[] $airAccommodation
     */
    public function __construct(array $airAccommodation = array())
    {
        $this
            ->setAirAccommodation($airAccommodation);
    }
    /**
     * Get AirAccommodation value
     * @return \StructType\AirAccommodation[]|null
     */
    public function getAirAccommodation()
    {
        return $this->AirAccommodation;
    }
    /**
     * This method is responsible for validating the values passed to the setAirAccommodation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirAccommodation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirAccommodationForArrayConstraintsFromSetAirAccommodation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airAccommodationsAirAccommodationItem) {
            // validation for constraint: itemType
            if (!$airAccommodationsAirAccommodationItem instanceof \StructType\AirAccommodation) {
                $invalidValues[] = is_object($airAccommodationsAirAccommodationItem) ? get_class($airAccommodationsAirAccommodationItem) : sprintf('%s(%s)', gettype($airAccommodationsAirAccommodationItem), var_export($airAccommodationsAirAccommodationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirAccommodation property can only contain items of type \StructType\AirAccommodation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirAccommodation value
     * @throws \InvalidArgumentException
     * @param \StructType\AirAccommodation[] $airAccommodation
     * @return \StructType\AirAccommodations
     */
    public function setAirAccommodation(array $airAccommodation = array())
    {
        // validation for constraint: array
        if ('' !== ($airAccommodationArrayErrorMessage = self::validateAirAccommodationForArrayConstraintsFromSetAirAccommodation($airAccommodation))) {
            throw new \InvalidArgumentException($airAccommodationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($airAccommodation) && count($airAccommodation) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($airAccommodation)), __LINE__);
        }
        $this->AirAccommodation = $airAccommodation;
        return $this;
    }
    /**
     * Add item to AirAccommodation value
     * @throws \InvalidArgumentException
     * @param \StructType\AirAccommodation $item
     * @return \StructType\AirAccommodations
     */
    public function addToAirAccommodation(\StructType\AirAccommodation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirAccommodation) {
            throw new \InvalidArgumentException(sprintf('The AirAccommodation property can only contain items of type \StructType\AirAccommodation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->AirAccommodation) && count($this->AirAccommodation) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->AirAccommodation)), __LINE__);
        }
        $this->AirAccommodation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirAccommodations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
