<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Age StructType
 * Meta information extracted from the WSDL
 * - documentation: Information associated with the age requirements of renting a vehicle.
 * - type: Numeric0to999
 * - use: optional
 * @subpackage Structs
 */
class Age extends AbstractStructBase
{
    /**
     * The AgeSurcharge
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\AgeSurcharge[]
     */
    public $AgeSurcharge;
    /**
     * The AgeInfos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AgeInfos
     */
    public $AgeInfos;
    /**
     * The Vehicles
     * @var \StructType\Vehicles
     */
    public $Vehicles;
    /**
     * The MinimumAge
     * Meta information extracted from the WSDL
     * - documentation: Identifies the minimum age of a person allowed to rent a vehicle from this rental facility.
     * - use: optional
     * @var int
     */
    public $MinimumAge;
    /**
     * The MaximumAge
     * Meta information extracted from the WSDL
     * - documentation: Identifies the maximum age of a person allowed to rent a vehicle from this rental facility.
     * - use: optional
     * @var int
     */
    public $MaximumAge;
    /**
     * Constructor method for Age
     * @uses Age::setAgeSurcharge()
     * @uses Age::setAgeInfos()
     * @uses Age::setVehicles()
     * @uses Age::setMinimumAge()
     * @uses Age::setMaximumAge()
     * @param \StructType\AgeSurcharge[] $ageSurcharge
     * @param \StructType\AgeInfos $ageInfos
     * @param \StructType\Vehicles $vehicles
     * @param int $minimumAge
     * @param int $maximumAge
     */
    public function __construct(array $ageSurcharge = array(), \StructType\AgeInfos $ageInfos = null, \StructType\Vehicles $vehicles = null, $minimumAge = null, $maximumAge = null)
    {
        $this
            ->setAgeSurcharge($ageSurcharge)
            ->setAgeInfos($ageInfos)
            ->setVehicles($vehicles)
            ->setMinimumAge($minimumAge)
            ->setMaximumAge($maximumAge);
    }
    /**
     * Get AgeSurcharge value
     * @return \StructType\AgeSurcharge[]|null
     */
    public function getAgeSurcharge()
    {
        return $this->AgeSurcharge;
    }
    /**
     * This method is responsible for validating the values passed to the setAgeSurcharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAgeSurcharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAgeSurchargeForArrayConstraintsFromSetAgeSurcharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ageAgeSurchargeItem) {
            // validation for constraint: itemType
            if (!$ageAgeSurchargeItem instanceof \StructType\AgeSurcharge) {
                $invalidValues[] = is_object($ageAgeSurchargeItem) ? get_class($ageAgeSurchargeItem) : sprintf('%s(%s)', gettype($ageAgeSurchargeItem), var_export($ageAgeSurchargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AgeSurcharge property can only contain items of type \StructType\AgeSurcharge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AgeSurcharge value
     * @throws \InvalidArgumentException
     * @param \StructType\AgeSurcharge[] $ageSurcharge
     * @return \StructType\Age
     */
    public function setAgeSurcharge(array $ageSurcharge = array())
    {
        // validation for constraint: array
        if ('' !== ($ageSurchargeArrayErrorMessage = self::validateAgeSurchargeForArrayConstraintsFromSetAgeSurcharge($ageSurcharge))) {
            throw new \InvalidArgumentException($ageSurchargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($ageSurcharge) && count($ageSurcharge) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($ageSurcharge)), __LINE__);
        }
        $this->AgeSurcharge = $ageSurcharge;
        return $this;
    }
    /**
     * Add item to AgeSurcharge value
     * @throws \InvalidArgumentException
     * @param \StructType\AgeSurcharge $item
     * @return \StructType\Age
     */
    public function addToAgeSurcharge(\StructType\AgeSurcharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AgeSurcharge) {
            throw new \InvalidArgumentException(sprintf('The AgeSurcharge property can only contain items of type \StructType\AgeSurcharge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->AgeSurcharge) && count($this->AgeSurcharge) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->AgeSurcharge)), __LINE__);
        }
        $this->AgeSurcharge[] = $item;
        return $this;
    }
    /**
     * Get AgeInfos value
     * @return \StructType\AgeInfos|null
     */
    public function getAgeInfos()
    {
        return $this->AgeInfos;
    }
    /**
     * Set AgeInfos value
     * @param \StructType\AgeInfos $ageInfos
     * @return \StructType\Age
     */
    public function setAgeInfos(\StructType\AgeInfos $ageInfos = null)
    {
        $this->AgeInfos = $ageInfos;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \StructType\Vehicles|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \StructType\Vehicles $vehicles
     * @return \StructType\Age
     */
    public function setVehicles(\StructType\Vehicles $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get MinimumAge value
     * @return int|null
     */
    public function getMinimumAge()
    {
        return $this->MinimumAge;
    }
    /**
     * Set MinimumAge value
     * @param int $minimumAge
     * @return \StructType\Age
     */
    public function setMinimumAge($minimumAge = null)
    {
        // validation for constraint: int
        if (!is_null($minimumAge) && !(is_int($minimumAge) || ctype_digit($minimumAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumAge, true), gettype($minimumAge)), __LINE__);
        }
        $this->MinimumAge = $minimumAge;
        return $this;
    }
    /**
     * Get MaximumAge value
     * @return int|null
     */
    public function getMaximumAge()
    {
        return $this->MaximumAge;
    }
    /**
     * Set MaximumAge value
     * @param int $maximumAge
     * @return \StructType\Age
     */
    public function setMaximumAge($maximumAge = null)
    {
        // validation for constraint: int
        if (!is_null($maximumAge) && !(is_int($maximumAge) || ctype_digit($maximumAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumAge, true), gettype($maximumAge)), __LINE__);
        }
        $this->MaximumAge = $maximumAge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Age
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
