<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffiliationInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: The AffiliationInfo object is used to identify the brand or franchise affiliations of the hotel.
 * @subpackage Structs
 */
class AffiliationInfoType extends AbstractStructBase
{
    /**
     * The DistribSystems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DistribSystems
     */
    public $DistribSystems;
    /**
     * The Brands
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Brands
     */
    public $Brands;
    /**
     * The LoyalPrograms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LoyalPrograms
     */
    public $LoyalPrograms;
    /**
     * The Awards
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Awards
     */
    public $Awards;
    /**
     * The PartnerInfos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PartnerInfos
     */
    public $PartnerInfos;
    /**
     * The Descriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Descriptions
     */
    public $Descriptions;
    /**
     * The LastUpdated
     * Meta information extracted from the WSDL
     * - documentation: The date and time when the affiliation information for this hotel was last updated.
     * - use: optional
     * @var string
     */
    public $LastUpdated;
    /**
     * Constructor method for AffiliationInfoType
     * @uses AffiliationInfoType::setDistribSystems()
     * @uses AffiliationInfoType::setBrands()
     * @uses AffiliationInfoType::setLoyalPrograms()
     * @uses AffiliationInfoType::setAwards()
     * @uses AffiliationInfoType::setPartnerInfos()
     * @uses AffiliationInfoType::setDescriptions()
     * @uses AffiliationInfoType::setLastUpdated()
     * @param \StructType\DistribSystems $distribSystems
     * @param \StructType\Brands $brands
     * @param \StructType\LoyalPrograms $loyalPrograms
     * @param \StructType\Awards $awards
     * @param \StructType\PartnerInfos $partnerInfos
     * @param \StructType\Descriptions $descriptions
     * @param string $lastUpdated
     */
    public function __construct(\StructType\DistribSystems $distribSystems = null, \StructType\Brands $brands = null, \StructType\LoyalPrograms $loyalPrograms = null, \StructType\Awards $awards = null, \StructType\PartnerInfos $partnerInfos = null, \StructType\Descriptions $descriptions = null, $lastUpdated = null)
    {
        $this
            ->setDistribSystems($distribSystems)
            ->setBrands($brands)
            ->setLoyalPrograms($loyalPrograms)
            ->setAwards($awards)
            ->setPartnerInfos($partnerInfos)
            ->setDescriptions($descriptions)
            ->setLastUpdated($lastUpdated);
    }
    /**
     * Get DistribSystems value
     * @return \StructType\DistribSystems|null
     */
    public function getDistribSystems()
    {
        return $this->DistribSystems;
    }
    /**
     * Set DistribSystems value
     * @param \StructType\DistribSystems $distribSystems
     * @return \StructType\AffiliationInfoType
     */
    public function setDistribSystems(\StructType\DistribSystems $distribSystems = null)
    {
        $this->DistribSystems = $distribSystems;
        return $this;
    }
    /**
     * Get Brands value
     * @return \StructType\Brands|null
     */
    public function getBrands()
    {
        return $this->Brands;
    }
    /**
     * Set Brands value
     * @param \StructType\Brands $brands
     * @return \StructType\AffiliationInfoType
     */
    public function setBrands(\StructType\Brands $brands = null)
    {
        $this->Brands = $brands;
        return $this;
    }
    /**
     * Get LoyalPrograms value
     * @return \StructType\LoyalPrograms|null
     */
    public function getLoyalPrograms()
    {
        return $this->LoyalPrograms;
    }
    /**
     * Set LoyalPrograms value
     * @param \StructType\LoyalPrograms $loyalPrograms
     * @return \StructType\AffiliationInfoType
     */
    public function setLoyalPrograms(\StructType\LoyalPrograms $loyalPrograms = null)
    {
        $this->LoyalPrograms = $loyalPrograms;
        return $this;
    }
    /**
     * Get Awards value
     * @return \StructType\Awards|null
     */
    public function getAwards()
    {
        return $this->Awards;
    }
    /**
     * Set Awards value
     * @param \StructType\Awards $awards
     * @return \StructType\AffiliationInfoType
     */
    public function setAwards(\StructType\Awards $awards = null)
    {
        $this->Awards = $awards;
        return $this;
    }
    /**
     * Get PartnerInfos value
     * @return \StructType\PartnerInfos|null
     */
    public function getPartnerInfos()
    {
        return $this->PartnerInfos;
    }
    /**
     * Set PartnerInfos value
     * @param \StructType\PartnerInfos $partnerInfos
     * @return \StructType\AffiliationInfoType
     */
    public function setPartnerInfos(\StructType\PartnerInfos $partnerInfos = null)
    {
        $this->PartnerInfos = $partnerInfos;
        return $this;
    }
    /**
     * Get Descriptions value
     * @return \StructType\Descriptions|null
     */
    public function getDescriptions()
    {
        return $this->Descriptions;
    }
    /**
     * Set Descriptions value
     * @param \StructType\Descriptions $descriptions
     * @return \StructType\AffiliationInfoType
     */
    public function setDescriptions(\StructType\Descriptions $descriptions = null)
    {
        $this->Descriptions = $descriptions;
        return $this;
    }
    /**
     * Get LastUpdated value
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->LastUpdated;
    }
    /**
     * Set LastUpdated value
     * @param string $lastUpdated
     * @return \StructType\AffiliationInfoType
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdated, true), gettype($lastUpdated)), __LINE__);
        }
        $this->LastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffiliationInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
