<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdvResTicketingType StructType
 * Meta information extracted from the WSDL
 * - documentation: Container used to hold information regarding advance reservation and/or advance ticketing.
 * @subpackage Structs
 */
class AdvResTicketingType extends AbstractStructBase
{
    /**
     * The AdvReservation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdvReservation
     */
    public $AdvReservation;
    /**
     * The AdvTicketing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdvTicketing
     */
    public $AdvTicketing;
    /**
     * The AdvResInd
     * Meta information extracted from the WSDL
     * - documentation: Indicator for identifying whether or not advance reservation restrictions are involved in the request or response.
     * @var bool
     */
    public $AdvResInd;
    /**
     * The AdvTicketingInd
     * Meta information extracted from the WSDL
     * - documentation: Indicator for identifying whether or not advance ticketing restrictions are involved in the request or response.
     * - use: optional
     * @var bool
     */
    public $AdvTicketingInd;
    /**
     * The RequestedTicketingDate
     * Meta information extracted from the WSDL
     * - documentation: The date a traveller wishes to ticket their reservation.
     * - use: optional
     * @var string
     */
    public $RequestedTicketingDate;
    /**
     * Constructor method for AdvResTicketingType
     * @uses AdvResTicketingType::setAdvReservation()
     * @uses AdvResTicketingType::setAdvTicketing()
     * @uses AdvResTicketingType::setAdvResInd()
     * @uses AdvResTicketingType::setAdvTicketingInd()
     * @uses AdvResTicketingType::setRequestedTicketingDate()
     * @param \StructType\AdvReservation $advReservation
     * @param \StructType\AdvTicketing $advTicketing
     * @param bool $advResInd
     * @param bool $advTicketingInd
     * @param string $requestedTicketingDate
     */
    public function __construct(\StructType\AdvReservation $advReservation = null, \StructType\AdvTicketing $advTicketing = null, $advResInd = null, $advTicketingInd = null, $requestedTicketingDate = null)
    {
        $this
            ->setAdvReservation($advReservation)
            ->setAdvTicketing($advTicketing)
            ->setAdvResInd($advResInd)
            ->setAdvTicketingInd($advTicketingInd)
            ->setRequestedTicketingDate($requestedTicketingDate);
    }
    /**
     * Get AdvReservation value
     * @return \StructType\AdvReservation|null
     */
    public function getAdvReservation()
    {
        return $this->AdvReservation;
    }
    /**
     * Set AdvReservation value
     * @param \StructType\AdvReservation $advReservation
     * @return \StructType\AdvResTicketingType
     */
    public function setAdvReservation(\StructType\AdvReservation $advReservation = null)
    {
        $this->AdvReservation = $advReservation;
        return $this;
    }
    /**
     * Get AdvTicketing value
     * @return \StructType\AdvTicketing|null
     */
    public function getAdvTicketing()
    {
        return $this->AdvTicketing;
    }
    /**
     * Set AdvTicketing value
     * @param \StructType\AdvTicketing $advTicketing
     * @return \StructType\AdvResTicketingType
     */
    public function setAdvTicketing(\StructType\AdvTicketing $advTicketing = null)
    {
        $this->AdvTicketing = $advTicketing;
        return $this;
    }
    /**
     * Get AdvResInd value
     * @return bool|null
     */
    public function getAdvResInd()
    {
        return $this->AdvResInd;
    }
    /**
     * Set AdvResInd value
     * @param bool $advResInd
     * @return \StructType\AdvResTicketingType
     */
    public function setAdvResInd($advResInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($advResInd) && !is_bool($advResInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($advResInd, true), gettype($advResInd)), __LINE__);
        }
        $this->AdvResInd = $advResInd;
        return $this;
    }
    /**
     * Get AdvTicketingInd value
     * @return bool|null
     */
    public function getAdvTicketingInd()
    {
        return $this->AdvTicketingInd;
    }
    /**
     * Set AdvTicketingInd value
     * @param bool $advTicketingInd
     * @return \StructType\AdvResTicketingType
     */
    public function setAdvTicketingInd($advTicketingInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($advTicketingInd) && !is_bool($advTicketingInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($advTicketingInd, true), gettype($advTicketingInd)), __LINE__);
        }
        $this->AdvTicketingInd = $advTicketingInd;
        return $this;
    }
    /**
     * Get RequestedTicketingDate value
     * @return string|null
     */
    public function getRequestedTicketingDate()
    {
        return $this->RequestedTicketingDate;
    }
    /**
     * Set RequestedTicketingDate value
     * @param string $requestedTicketingDate
     * @return \StructType\AdvResTicketingType
     */
    public function setRequestedTicketingDate($requestedTicketingDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestedTicketingDate) && !is_string($requestedTicketingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedTicketingDate, true), gettype($requestedTicketingDate)), __LINE__);
        }
        $this->RequestedTicketingDate = $requestedTicketingDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdvResTicketingType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
