<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressType StructType
 * Meta information extracted from the WSDL
 * - documentation: Allows for control of the sharing of address information between parties. | Specifies if the associated data is formatted or not. When true, then it is formatted; when false, then not formatted. | Provides address information.
 * @subpackage Structs
 */
class AddressType extends AbstractStructBase
{
    /**
     * The StreetNmbr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StreetNmbr
     */
    public $StreetNmbr;
    /**
     * The BldgRoom
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\BldgRoom[]
     */
    public $BldgRoom;
    /**
     * The AddressLine
     * Meta information extracted from the WSDL
     * - documentation: When the address is unformatted (FormattedInd="false") these lines will contain free form address details. When the address is formatted and street number and street name must be sent independently, the street number will be sent
     * using StreetNmbr, and the street name will be sent in the first AddressLine occurrence.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $AddressLine;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - documentation: City (e.g., Dublin), town, or postal station (i.e., a postal service territory, often used in a military address).
     * - minOccurs: 0
     * @var mixed
     */
    public $CityName;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - documentation: Post Office Code number.
     * - minOccurs: 0
     * @var mixed
     */
    public $PostalCode;
    /**
     * The County
     * Meta information extracted from the WSDL
     * - documentation: County or Region Name (e.g., Fairfax).
     * - minOccurs: 0
     * @var mixed
     */
    public $County;
    /**
     * The StateProv
     * Meta information extracted from the WSDL
     * - documentation: State or Province name (e.g., Texas).
     * - minOccurs: 0
     * @var mixed
     */
    public $StateProv;
    /**
     * The CountryName
     * Meta information extracted from the WSDL
     * - documentation: Country name (e.g., Ireland).
     * - minOccurs: 0
     * @var mixed
     */
    public $CountryName;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Defines the type of address (e.g. home, business, other). Refer to OpenTravel Code List Communication Location Type (CLT).
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: A remark associated with this address.
     * - use: optional
     * @var string
     */
    public $Remark;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - documentation: Example: en | Address language.
     * - use: optional
     * @var string
     */
    public $Language;
    /**
     * The ValidInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, this is a valid and complete mailing address that has been verified through an address verification service or previously mailed materials have not been returned. | Example: true | Valid email address indicator.
     * - use: optional
     * @var bool
     */
    public $ValidInd;
    /**
     * Constructor method for AddressType
     * @uses AddressType::setStreetNmbr()
     * @uses AddressType::setBldgRoom()
     * @uses AddressType::setAddressLine()
     * @uses AddressType::setCityName()
     * @uses AddressType::setPostalCode()
     * @uses AddressType::setCounty()
     * @uses AddressType::setStateProv()
     * @uses AddressType::setCountryName()
     * @uses AddressType::setType()
     * @uses AddressType::setRemark()
     * @uses AddressType::setLanguage()
     * @uses AddressType::setValidInd()
     * @param \StructType\StreetNmbr $streetNmbr
     * @param \StructType\BldgRoom[] $bldgRoom
     * @param mixed[] $addressLine
     * @param mixed $cityName
     * @param mixed $postalCode
     * @param mixed $county
     * @param mixed $stateProv
     * @param mixed $countryName
     * @param string $type
     * @param string $remark
     * @param string $language
     * @param bool $validInd
     */
    public function __construct(\StructType\StreetNmbr $streetNmbr = null, array $bldgRoom = array(), array $addressLine = array(), $cityName = null, $postalCode = null, $county = null, $stateProv = null, $countryName = null, $type = null, $remark = null, $language = null, $validInd = null)
    {
        $this
            ->setStreetNmbr($streetNmbr)
            ->setBldgRoom($bldgRoom)
            ->setAddressLine($addressLine)
            ->setCityName($cityName)
            ->setPostalCode($postalCode)
            ->setCounty($county)
            ->setStateProv($stateProv)
            ->setCountryName($countryName)
            ->setType($type)
            ->setRemark($remark)
            ->setLanguage($language)
            ->setValidInd($validInd);
    }
    /**
     * Get StreetNmbr value
     * @return \StructType\StreetNmbr|null
     */
    public function getStreetNmbr()
    {
        return $this->StreetNmbr;
    }
    /**
     * Set StreetNmbr value
     * @param \StructType\StreetNmbr $streetNmbr
     * @return \StructType\AddressType
     */
    public function setStreetNmbr(\StructType\StreetNmbr $streetNmbr = null)
    {
        $this->StreetNmbr = $streetNmbr;
        return $this;
    }
    /**
     * Get BldgRoom value
     * @return \StructType\BldgRoom[]|null
     */
    public function getBldgRoom()
    {
        return $this->BldgRoom;
    }
    /**
     * This method is responsible for validating the values passed to the setBldgRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBldgRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBldgRoomForArrayConstraintsFromSetBldgRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressTypeBldgRoomItem) {
            // validation for constraint: itemType
            if (!$addressTypeBldgRoomItem instanceof \StructType\BldgRoom) {
                $invalidValues[] = is_object($addressTypeBldgRoomItem) ? get_class($addressTypeBldgRoomItem) : sprintf('%s(%s)', gettype($addressTypeBldgRoomItem), var_export($addressTypeBldgRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BldgRoom property can only contain items of type \StructType\BldgRoom, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BldgRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\BldgRoom[] $bldgRoom
     * @return \StructType\AddressType
     */
    public function setBldgRoom(array $bldgRoom = array())
    {
        // validation for constraint: array
        if ('' !== ($bldgRoomArrayErrorMessage = self::validateBldgRoomForArrayConstraintsFromSetBldgRoom($bldgRoom))) {
            throw new \InvalidArgumentException($bldgRoomArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($bldgRoom) && count($bldgRoom) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($bldgRoom)), __LINE__);
        }
        $this->BldgRoom = $bldgRoom;
        return $this;
    }
    /**
     * Add item to BldgRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\BldgRoom $item
     * @return \StructType\AddressType
     */
    public function addToBldgRoom(\StructType\BldgRoom $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BldgRoom) {
            throw new \InvalidArgumentException(sprintf('The BldgRoom property can only contain items of type \StructType\BldgRoom, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->BldgRoom) && count($this->BldgRoom) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->BldgRoom)), __LINE__);
        }
        $this->BldgRoom[] = $item;
        return $this;
    }
    /**
     * Get AddressLine value
     * @return mixed[]|null
     */
    public function getAddressLine()
    {
        return $this->AddressLine;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressLineForArrayConstraintsFromSetAddressLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressTypeAddressLineItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($addressTypeAddressLineItem) ? get_class($addressTypeAddressLineItem) : sprintf('%s(%s)', gettype($addressTypeAddressLineItem), var_export($addressTypeAddressLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddressLine property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddressLine value
     * @throws \InvalidArgumentException
     * @param mixed[] $addressLine
     * @return \StructType\AddressType
     */
    public function setAddressLine(array $addressLine = array())
    {
        // validation for constraint: array
        if ('' !== ($addressLineArrayErrorMessage = self::validateAddressLineForArrayConstraintsFromSetAddressLine($addressLine))) {
            throw new \InvalidArgumentException($addressLineArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($addressLine) && count($addressLine) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($addressLine)), __LINE__);
        }
        $this->AddressLine = $addressLine;
        return $this;
    }
    /**
     * Add item to AddressLine value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AddressType
     */
    public function addToAddressLine($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The AddressLine property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->AddressLine) && count($this->AddressLine) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->AddressLine)), __LINE__);
        }
        $this->AddressLine[] = $item;
        return $this;
    }
    /**
     * Get CityName value
     * @return mixed|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param mixed $cityName
     * @return \StructType\AddressType
     */
    public function setCityName($cityName = null)
    {
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return mixed|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param mixed $postalCode
     * @return \StructType\AddressType
     */
    public function setPostalCode($postalCode = null)
    {
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get County value
     * @return mixed|null
     */
    public function getCounty()
    {
        return $this->County;
    }
    /**
     * Set County value
     * @param mixed $county
     * @return \StructType\AddressType
     */
    public function setCounty($county = null)
    {
        $this->County = $county;
        return $this;
    }
    /**
     * Get StateProv value
     * @return mixed|null
     */
    public function getStateProv()
    {
        return $this->StateProv;
    }
    /**
     * Set StateProv value
     * @param mixed $stateProv
     * @return \StructType\AddressType
     */
    public function setStateProv($stateProv = null)
    {
        $this->StateProv = $stateProv;
        return $this;
    }
    /**
     * Get CountryName value
     * @return mixed|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param mixed $countryName
     * @return \StructType\AddressType
     */
    public function setCountryName($countryName = null)
    {
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\AddressType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\AddressType
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\AddressType
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get ValidInd value
     * @return bool|null
     */
    public function getValidInd()
    {
        return $this->ValidInd;
    }
    /**
     * Set ValidInd value
     * @param bool $validInd
     * @return \StructType\AddressType
     */
    public function setValidInd($validInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($validInd) && !is_bool($validInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($validInd, true), gettype($validInd)), __LINE__);
        }
        $this->ValidInd = $validInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
