<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates whether or not this is the default address. | Information about an address that identifies a location for a specific purposes.
 * @subpackage Structs
 */
class AddressInfoType extends AddressType
{
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The UseType
     * Meta information extracted from the WSDL
     * - documentation: Describes the use of the address (e.g. mailing, delivery, billing, etc.). Refer to OpenTravel Code List Address Use Type (AUT).
     * - use: optional
     * @var string
     */
    public $UseType;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Used elsewhere in the message to reference this specific address.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for AddressInfoType
     * @uses AddressInfoType::setTPA_Extensions()
     * @uses AddressInfoType::setUseType()
     * @uses AddressInfoType::setRPH()
     * @param mixed $tPA_Extensions
     * @param string $useType
     * @param string $rPH
     */
    public function __construct($tPA_Extensions = null, $useType = null, $rPH = null)
    {
        $this
            ->setTPA_Extensions($tPA_Extensions)
            ->setUseType($useType)
            ->setRPH($rPH);
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\AddressInfoType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get UseType value
     * @return string|null
     */
    public function getUseType()
    {
        return $this->UseType;
    }
    /**
     * Set UseType value
     * @param string $useType
     * @return \StructType\AddressInfoType
     */
    public function setUseType($useType = null)
    {
        // validation for constraint: string
        if (!is_null($useType) && !is_string($useType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useType, true), gettype($useType)), __LINE__);
        }
        $this->UseType = $useType;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\AddressInfoType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
