<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddlDriverInfos StructType
 * Meta information extracted from the WSDL
 * - documentation: The charge for an additional driver. | The effective and discontinue dates for the additional driver information. | Collection of descriptions about the different requirements related to additional drivers.
 * @subpackage Structs
 */
class AddlDriverInfos extends AbstractStructBase
{
    /**
     * The AddlDriverInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\AddlDriverInfo[]
     */
    public $AddlDriverInfo;
    /**
     * The Vehicles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Vehicles
     */
    public $Vehicles;
    /**
     * The ChargeType
     * Meta information extracted from the WSDL
     * - documentation: To specify if the charge is per rental, day, etc. Refer to OpenTravel Charge Type code list (CHG).
     * - use: optional
     * @var string
     */
    public $ChargeType;
    /**
     * Constructor method for AddlDriverInfos
     * @uses AddlDriverInfos::setAddlDriverInfo()
     * @uses AddlDriverInfos::setVehicles()
     * @uses AddlDriverInfos::setChargeType()
     * @param \StructType\AddlDriverInfo[] $addlDriverInfo
     * @param \StructType\Vehicles $vehicles
     * @param string $chargeType
     */
    public function __construct(array $addlDriverInfo = array(), \StructType\Vehicles $vehicles = null, $chargeType = null)
    {
        $this
            ->setAddlDriverInfo($addlDriverInfo)
            ->setVehicles($vehicles)
            ->setChargeType($chargeType);
    }
    /**
     * Get AddlDriverInfo value
     * @return \StructType\AddlDriverInfo[]|null
     */
    public function getAddlDriverInfo()
    {
        return $this->AddlDriverInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setAddlDriverInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddlDriverInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddlDriverInfoForArrayConstraintsFromSetAddlDriverInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addlDriverInfosAddlDriverInfoItem) {
            // validation for constraint: itemType
            if (!$addlDriverInfosAddlDriverInfoItem instanceof \StructType\AddlDriverInfo) {
                $invalidValues[] = is_object($addlDriverInfosAddlDriverInfoItem) ? get_class($addlDriverInfosAddlDriverInfoItem) : sprintf('%s(%s)', gettype($addlDriverInfosAddlDriverInfoItem), var_export($addlDriverInfosAddlDriverInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddlDriverInfo property can only contain items of type \StructType\AddlDriverInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddlDriverInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\AddlDriverInfo[] $addlDriverInfo
     * @return \StructType\AddlDriverInfos
     */
    public function setAddlDriverInfo(array $addlDriverInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($addlDriverInfoArrayErrorMessage = self::validateAddlDriverInfoForArrayConstraintsFromSetAddlDriverInfo($addlDriverInfo))) {
            throw new \InvalidArgumentException($addlDriverInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($addlDriverInfo) && count($addlDriverInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($addlDriverInfo)), __LINE__);
        }
        $this->AddlDriverInfo = $addlDriverInfo;
        return $this;
    }
    /**
     * Add item to AddlDriverInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\AddlDriverInfo $item
     * @return \StructType\AddlDriverInfos
     */
    public function addToAddlDriverInfo(\StructType\AddlDriverInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddlDriverInfo) {
            throw new \InvalidArgumentException(sprintf('The AddlDriverInfo property can only contain items of type \StructType\AddlDriverInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->AddlDriverInfo) && count($this->AddlDriverInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->AddlDriverInfo)), __LINE__);
        }
        $this->AddlDriverInfo[] = $item;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \StructType\Vehicles|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \StructType\Vehicles $vehicles
     * @return \StructType\AddlDriverInfos
     */
    public function setVehicles(\StructType\Vehicles $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get ChargeType value
     * @return string|null
     */
    public function getChargeType()
    {
        return $this->ChargeType;
    }
    /**
     * Set ChargeType value
     * @param string $chargeType
     * @return \StructType\AddlDriverInfos
     */
    public function setChargeType($chargeType = null)
    {
        // validation for constraint: string
        if (!is_null($chargeType) && !is_string($chargeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeType, true), gettype($chargeType)), __LINE__);
        }
        $this->ChargeType = $chargeType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddlDriverInfos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
