<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalGuestAmounts StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of charges that apply to for additional occupants, guests or service users (over and above the rate's MaxGuest Applicable).
 * @subpackage Structs
 */
class AdditionalGuestAmounts extends AbstractStructBase
{
    /**
     * The AdditionalGuestAmount
     * Meta information extracted from the WSDL
     * - documentation: Collection of incremental charges per age qualifying code for additional guests. Amount charged for additional occupant is with respect to age group of the base guests.
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $AdditionalGuestAmount;
    /**
     * The AmountBeforeTax
     * Meta information extracted from the WSDL
     * - use: optional
     * @var float
     */
    public $AmountBeforeTax;
    /**
     * The AmountAfterTax
     * Meta information extracted from the WSDL
     * - use: optional
     * @var float
     */
    public $AmountAfterTax;
    /**
     * Constructor method for AdditionalGuestAmounts
     * @uses AdditionalGuestAmounts::setAdditionalGuestAmount()
     * @uses AdditionalGuestAmounts::setAmountBeforeTax()
     * @uses AdditionalGuestAmounts::setAmountAfterTax()
     * @param mixed[] $additionalGuestAmount
     * @param float $amountBeforeTax
     * @param float $amountAfterTax
     */
    public function __construct(array $additionalGuestAmount = array(), $amountBeforeTax = null, $amountAfterTax = null)
    {
        $this
            ->setAdditionalGuestAmount($additionalGuestAmount)
            ->setAmountBeforeTax($amountBeforeTax)
            ->setAmountAfterTax($amountAfterTax);
    }
    /**
     * Get AdditionalGuestAmount value
     * @return mixed[]|null
     */
    public function getAdditionalGuestAmount()
    {
        return $this->AdditionalGuestAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalGuestAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalGuestAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalGuestAmountForArrayConstraintsFromSetAdditionalGuestAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $additionalGuestAmountsAdditionalGuestAmountItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($additionalGuestAmountsAdditionalGuestAmountItem) ? get_class($additionalGuestAmountsAdditionalGuestAmountItem) : sprintf('%s(%s)', gettype($additionalGuestAmountsAdditionalGuestAmountItem), var_export($additionalGuestAmountsAdditionalGuestAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalGuestAmount property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalGuestAmount value
     * @throws \InvalidArgumentException
     * @param mixed[] $additionalGuestAmount
     * @return \StructType\AdditionalGuestAmounts
     */
    public function setAdditionalGuestAmount(array $additionalGuestAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalGuestAmountArrayErrorMessage = self::validateAdditionalGuestAmountForArrayConstraintsFromSetAdditionalGuestAmount($additionalGuestAmount))) {
            throw new \InvalidArgumentException($additionalGuestAmountArrayErrorMessage, __LINE__);
        }
        $this->AdditionalGuestAmount = $additionalGuestAmount;
        return $this;
    }
    /**
     * Add item to AdditionalGuestAmount value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AdditionalGuestAmounts
     */
    public function addToAdditionalGuestAmount($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The AdditionalGuestAmount property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalGuestAmount[] = $item;
        return $this;
    }
    /**
     * Get AmountBeforeTax value
     * @return float|null
     */
    public function getAmountBeforeTax()
    {
        return $this->AmountBeforeTax;
    }
    /**
     * Set AmountBeforeTax value
     * @param float $amountBeforeTax
     * @return \StructType\AdditionalGuestAmounts
     */
    public function setAmountBeforeTax($amountBeforeTax = null)
    {
        // validation for constraint: float
        if (!is_null($amountBeforeTax) && !(is_float($amountBeforeTax) || is_numeric($amountBeforeTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountBeforeTax, true), gettype($amountBeforeTax)), __LINE__);
        }
        $this->AmountBeforeTax = $amountBeforeTax;
        return $this;
    }
    /**
     * Get AmountAfterTax value
     * @return float|null
     */
    public function getAmountAfterTax()
    {
        return $this->AmountAfterTax;
    }
    /**
     * Set AmountAfterTax value
     * @param float $amountAfterTax
     * @return \StructType\AdditionalGuestAmounts
     */
    public function setAmountAfterTax($amountAfterTax = null)
    {
        // validation for constraint: float
        if (!is_null($amountAfterTax) && !(is_float($amountAfterTax) || is_numeric($amountAfterTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountAfterTax, true), gettype($amountAfterTax)), __LINE__);
        }
        $this->AmountAfterTax = $amountAfterTax;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalGuestAmounts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
