<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalGuestAmountType StructType
 * Meta information extracted from the WSDL
 * - documentation: Charges related to additional guests.
 * @subpackage Structs
 */
class AdditionalGuestAmountType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount charged for an additional guest.
     * @var mixed
     */
    public $Amount;
    /**
     * The AddlGuestAmtDescription
     * Meta information extracted from the WSDL
     * - documentation: Descriptive information regarding amounts charged for additional guests.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $AddlGuestAmtDescription;
    /**
     * The MaxAdditionalGuests
     * Meta information extracted from the WSDL
     * - documentation: Increase the base rate by the additional occupant amount for each additional occupant of the same age group up to this maximum number of occupants of this age group.
     * - use: optional
     * @var int
     */
    public $MaxAdditionalGuests;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: A code representing the charges related to additional guests. Refer to OpenTravel Code List Additional Detail Type (ADT). Typically, the extra person information code would be used here.
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: The percent charged for an additional guest.
     * - use: optional
     * @var float
     */
    public $Percent;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: An index code to identify an instance in a collection of like items.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for AdditionalGuestAmountType
     * @uses AdditionalGuestAmountType::setAmount()
     * @uses AdditionalGuestAmountType::setAddlGuestAmtDescription()
     * @uses AdditionalGuestAmountType::setMaxAdditionalGuests()
     * @uses AdditionalGuestAmountType::setType()
     * @uses AdditionalGuestAmountType::setPercent()
     * @uses AdditionalGuestAmountType::setRPH()
     * @param mixed $amount
     * @param mixed[] $addlGuestAmtDescription
     * @param int $maxAdditionalGuests
     * @param string $type
     * @param float $percent
     * @param string $rPH
     */
    public function __construct($amount = null, array $addlGuestAmtDescription = array(), $maxAdditionalGuests = null, $type = null, $percent = null, $rPH = null)
    {
        $this
            ->setAmount($amount)
            ->setAddlGuestAmtDescription($addlGuestAmtDescription)
            ->setMaxAdditionalGuests($maxAdditionalGuests)
            ->setType($type)
            ->setPercent($percent)
            ->setRPH($rPH);
    }
    /**
     * Get Amount value
     * @return mixed|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param mixed $amount
     * @return \StructType\AdditionalGuestAmountType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get AddlGuestAmtDescription value
     * @return mixed[]|null
     */
    public function getAddlGuestAmtDescription()
    {
        return $this->AddlGuestAmtDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setAddlGuestAmtDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddlGuestAmtDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddlGuestAmtDescriptionForArrayConstraintsFromSetAddlGuestAmtDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $additionalGuestAmountTypeAddlGuestAmtDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($additionalGuestAmountTypeAddlGuestAmtDescriptionItem) ? get_class($additionalGuestAmountTypeAddlGuestAmtDescriptionItem) : sprintf('%s(%s)', gettype($additionalGuestAmountTypeAddlGuestAmtDescriptionItem), var_export($additionalGuestAmountTypeAddlGuestAmtDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddlGuestAmtDescription property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddlGuestAmtDescription value
     * @throws \InvalidArgumentException
     * @param mixed[] $addlGuestAmtDescription
     * @return \StructType\AdditionalGuestAmountType
     */
    public function setAddlGuestAmtDescription(array $addlGuestAmtDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($addlGuestAmtDescriptionArrayErrorMessage = self::validateAddlGuestAmtDescriptionForArrayConstraintsFromSetAddlGuestAmtDescription($addlGuestAmtDescription))) {
            throw new \InvalidArgumentException($addlGuestAmtDescriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($addlGuestAmtDescription) && count($addlGuestAmtDescription) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($addlGuestAmtDescription)), __LINE__);
        }
        $this->AddlGuestAmtDescription = $addlGuestAmtDescription;
        return $this;
    }
    /**
     * Add item to AddlGuestAmtDescription value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AdditionalGuestAmountType
     */
    public function addToAddlGuestAmtDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The AddlGuestAmtDescription property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->AddlGuestAmtDescription) && count($this->AddlGuestAmtDescription) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->AddlGuestAmtDescription)), __LINE__);
        }
        $this->AddlGuestAmtDescription[] = $item;
        return $this;
    }
    /**
     * Get MaxAdditionalGuests value
     * @return int|null
     */
    public function getMaxAdditionalGuests()
    {
        return $this->MaxAdditionalGuests;
    }
    /**
     * Set MaxAdditionalGuests value
     * @param int $maxAdditionalGuests
     * @return \StructType\AdditionalGuestAmountType
     */
    public function setMaxAdditionalGuests($maxAdditionalGuests = null)
    {
        // validation for constraint: int
        if (!is_null($maxAdditionalGuests) && !(is_int($maxAdditionalGuests) || ctype_digit($maxAdditionalGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAdditionalGuests, true), gettype($maxAdditionalGuests)), __LINE__);
        }
        $this->MaxAdditionalGuests = $maxAdditionalGuests;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\AdditionalGuestAmountType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\AdditionalGuestAmountType
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\AdditionalGuestAmountType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalGuestAmountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
