<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalGuestAmount StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of incremental charges per age qualifying code for additional guests. Amount charged for additional occupant is with respect to age group of the base guests.
 * @subpackage Structs
 */
class AdditionalGuestAmount extends AbstractStructBase
{
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $Taxes;
    /**
     * The AddlGuestAmtDescription
     * Meta information extracted from the WSDL
     * - documentation: Text description of the AdditionalGuestAmount in a given language.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $AddlGuestAmtDescription;
    /**
     * The TaxInclusive
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether taxes are included when figuring the additional occupant amounts.
     * - use: optional
     * @var bool
     */
    public $TaxInclusive;
    /**
     * The MaxAdditionalGuests
     * Meta information extracted from the WSDL
     * - documentation: Increase the base rate by the additional occupant amount for each additional occupant of the same age group up to this maximum number of occupants of this age group.
     * - use: optional
     * @var int
     */
    public $MaxAdditionalGuests;
    /**
     * Constructor method for AdditionalGuestAmount
     * @uses AdditionalGuestAmount::setTaxes()
     * @uses AdditionalGuestAmount::setAddlGuestAmtDescription()
     * @uses AdditionalGuestAmount::setTaxInclusive()
     * @uses AdditionalGuestAmount::setMaxAdditionalGuests()
     * @param mixed $taxes
     * @param mixed[] $addlGuestAmtDescription
     * @param bool $taxInclusive
     * @param int $maxAdditionalGuests
     */
    public function __construct($taxes = null, array $addlGuestAmtDescription = array(), $taxInclusive = null, $maxAdditionalGuests = null)
    {
        $this
            ->setTaxes($taxes)
            ->setAddlGuestAmtDescription($addlGuestAmtDescription)
            ->setTaxInclusive($taxInclusive)
            ->setMaxAdditionalGuests($maxAdditionalGuests);
    }
    /**
     * Get Taxes value
     * @return mixed|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param mixed $taxes
     * @return \StructType\AdditionalGuestAmount
     */
    public function setTaxes($taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get AddlGuestAmtDescription value
     * @return mixed[]|null
     */
    public function getAddlGuestAmtDescription()
    {
        return $this->AddlGuestAmtDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setAddlGuestAmtDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddlGuestAmtDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddlGuestAmtDescriptionForArrayConstraintsFromSetAddlGuestAmtDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $additionalGuestAmountAddlGuestAmtDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($additionalGuestAmountAddlGuestAmtDescriptionItem) ? get_class($additionalGuestAmountAddlGuestAmtDescriptionItem) : sprintf('%s(%s)', gettype($additionalGuestAmountAddlGuestAmtDescriptionItem), var_export($additionalGuestAmountAddlGuestAmtDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddlGuestAmtDescription property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddlGuestAmtDescription value
     * @throws \InvalidArgumentException
     * @param mixed[] $addlGuestAmtDescription
     * @return \StructType\AdditionalGuestAmount
     */
    public function setAddlGuestAmtDescription(array $addlGuestAmtDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($addlGuestAmtDescriptionArrayErrorMessage = self::validateAddlGuestAmtDescriptionForArrayConstraintsFromSetAddlGuestAmtDescription($addlGuestAmtDescription))) {
            throw new \InvalidArgumentException($addlGuestAmtDescriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($addlGuestAmtDescription) && count($addlGuestAmtDescription) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($addlGuestAmtDescription)), __LINE__);
        }
        $this->AddlGuestAmtDescription = $addlGuestAmtDescription;
        return $this;
    }
    /**
     * Add item to AddlGuestAmtDescription value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AdditionalGuestAmount
     */
    public function addToAddlGuestAmtDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The AddlGuestAmtDescription property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->AddlGuestAmtDescription) && count($this->AddlGuestAmtDescription) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->AddlGuestAmtDescription)), __LINE__);
        }
        $this->AddlGuestAmtDescription[] = $item;
        return $this;
    }
    /**
     * Get TaxInclusive value
     * @return bool|null
     */
    public function getTaxInclusive()
    {
        return $this->TaxInclusive;
    }
    /**
     * Set TaxInclusive value
     * @param bool $taxInclusive
     * @return \StructType\AdditionalGuestAmount
     */
    public function setTaxInclusive($taxInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusive) && !is_bool($taxInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxInclusive, true), gettype($taxInclusive)), __LINE__);
        }
        $this->TaxInclusive = $taxInclusive;
        return $this;
    }
    /**
     * Get MaxAdditionalGuests value
     * @return int|null
     */
    public function getMaxAdditionalGuests()
    {
        return $this->MaxAdditionalGuests;
    }
    /**
     * Set MaxAdditionalGuests value
     * @param int $maxAdditionalGuests
     * @return \StructType\AdditionalGuestAmount
     */
    public function setMaxAdditionalGuests($maxAdditionalGuests = null)
    {
        // validation for constraint: int
        if (!is_null($maxAdditionalGuests) && !(is_int($maxAdditionalGuests) || ctype_digit($maxAdditionalGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAdditionalGuests, true), gettype($maxAdditionalGuests)), __LINE__);
        }
        $this->MaxAdditionalGuests = $maxAdditionalGuests;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalGuestAmount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
