<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccommodationInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides accommodation location, dates and classifications
 * @subpackage Structs
 */
class AccommodationInfoType extends AbstractStructBase
{
    /**
     * The Property
     * Meta information extracted from the WSDL
     * - documentation: Full name or description plus codes for a property.
     * @var mixed
     */
    public $Property;
    /**
     * The Resort
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Resort
     */
    public $Resort;
    /**
     * The AccommodationClass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccommodationClass
     */
    public $AccommodationClass;
    /**
     * The SourceIdentification
     * Meta information extracted from the WSDL
     * - documentation: Identifies the current source for information on the property.
     * - minOccurs: 0
     * @var mixed
     */
    public $SourceIdentification;
    /**
     * The ContentInfo
     * Meta information extracted from the WSDL
     * - documentation: Provides a URL source for content information on the property.
     * - minOccurs: 0
     * @var mixed
     */
    public $ContentInfo;
    /**
     * The PackageID
     * Meta information extracted from the WSDL
     * - documentation: A code identifying a complete package arrangement, in place of individual travel and accommodation codes.
     * - use: optional
     * @var mixed
     */
    public $PackageID;
    /**
     * The MinChildAge
     * Meta information extracted from the WSDL
     * - documentation: The minimum age for a child price.
     * - use: optional
     * @var int
     */
    public $MinChildAge;
    /**
     * The MaxChildAge
     * Meta information extracted from the WSDL
     * - documentation: The maximum age for a child price.
     * - use: optional
     * @var int
     */
    public $MaxChildAge;
    /**
     * The BaseMealPlan
     * Meta information extracted from the WSDL
     * - documentation: This is the meal plan that is included in the package price.
     * - use: optional
     * @var string
     */
    public $BaseMealPlan;
    /**
     * Constructor method for AccommodationInfoType
     * @uses AccommodationInfoType::setProperty()
     * @uses AccommodationInfoType::setResort()
     * @uses AccommodationInfoType::setAccommodationClass()
     * @uses AccommodationInfoType::setSourceIdentification()
     * @uses AccommodationInfoType::setContentInfo()
     * @uses AccommodationInfoType::setPackageID()
     * @uses AccommodationInfoType::setMinChildAge()
     * @uses AccommodationInfoType::setMaxChildAge()
     * @uses AccommodationInfoType::setBaseMealPlan()
     * @param mixed $property
     * @param \StructType\Resort $resort
     * @param \StructType\AccommodationClass $accommodationClass
     * @param mixed $sourceIdentification
     * @param mixed $contentInfo
     * @param mixed $packageID
     * @param int $minChildAge
     * @param int $maxChildAge
     * @param string $baseMealPlan
     */
    public function __construct($property = null, \StructType\Resort $resort = null, \StructType\AccommodationClass $accommodationClass = null, $sourceIdentification = null, $contentInfo = null, $packageID = null, $minChildAge = null, $maxChildAge = null, $baseMealPlan = null)
    {
        $this
            ->setProperty($property)
            ->setResort($resort)
            ->setAccommodationClass($accommodationClass)
            ->setSourceIdentification($sourceIdentification)
            ->setContentInfo($contentInfo)
            ->setPackageID($packageID)
            ->setMinChildAge($minChildAge)
            ->setMaxChildAge($maxChildAge)
            ->setBaseMealPlan($baseMealPlan);
    }
    /**
     * Get Property value
     * @return mixed|null
     */
    public function getProperty()
    {
        return $this->Property;
    }
    /**
     * Set Property value
     * @param mixed $property
     * @return \StructType\AccommodationInfoType
     */
    public function setProperty($property = null)
    {
        $this->Property = $property;
        return $this;
    }
    /**
     * Get Resort value
     * @return \StructType\Resort|null
     */
    public function getResort()
    {
        return $this->Resort;
    }
    /**
     * Set Resort value
     * @param \StructType\Resort $resort
     * @return \StructType\AccommodationInfoType
     */
    public function setResort(\StructType\Resort $resort = null)
    {
        $this->Resort = $resort;
        return $this;
    }
    /**
     * Get AccommodationClass value
     * @return \StructType\AccommodationClass|null
     */
    public function getAccommodationClass()
    {
        return $this->AccommodationClass;
    }
    /**
     * Set AccommodationClass value
     * @param \StructType\AccommodationClass $accommodationClass
     * @return \StructType\AccommodationInfoType
     */
    public function setAccommodationClass(\StructType\AccommodationClass $accommodationClass = null)
    {
        $this->AccommodationClass = $accommodationClass;
        return $this;
    }
    /**
     * Get SourceIdentification value
     * @return mixed|null
     */
    public function getSourceIdentification()
    {
        return $this->SourceIdentification;
    }
    /**
     * Set SourceIdentification value
     * @param mixed $sourceIdentification
     * @return \StructType\AccommodationInfoType
     */
    public function setSourceIdentification($sourceIdentification = null)
    {
        $this->SourceIdentification = $sourceIdentification;
        return $this;
    }
    /**
     * Get ContentInfo value
     * @return mixed|null
     */
    public function getContentInfo()
    {
        return $this->ContentInfo;
    }
    /**
     * Set ContentInfo value
     * @param mixed $contentInfo
     * @return \StructType\AccommodationInfoType
     */
    public function setContentInfo($contentInfo = null)
    {
        $this->ContentInfo = $contentInfo;
        return $this;
    }
    /**
     * Get PackageID value
     * @return mixed|null
     */
    public function getPackageID()
    {
        return $this->PackageID;
    }
    /**
     * Set PackageID value
     * @param mixed $packageID
     * @return \StructType\AccommodationInfoType
     */
    public function setPackageID($packageID = null)
    {
        $this->PackageID = $packageID;
        return $this;
    }
    /**
     * Get MinChildAge value
     * @return int|null
     */
    public function getMinChildAge()
    {
        return $this->MinChildAge;
    }
    /**
     * Set MinChildAge value
     * @param int $minChildAge
     * @return \StructType\AccommodationInfoType
     */
    public function setMinChildAge($minChildAge = null)
    {
        // validation for constraint: int
        if (!is_null($minChildAge) && !(is_int($minChildAge) || ctype_digit($minChildAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minChildAge, true), gettype($minChildAge)), __LINE__);
        }
        $this->MinChildAge = $minChildAge;
        return $this;
    }
    /**
     * Get MaxChildAge value
     * @return int|null
     */
    public function getMaxChildAge()
    {
        return $this->MaxChildAge;
    }
    /**
     * Set MaxChildAge value
     * @param int $maxChildAge
     * @return \StructType\AccommodationInfoType
     */
    public function setMaxChildAge($maxChildAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxChildAge) && !(is_int($maxChildAge) || ctype_digit($maxChildAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxChildAge, true), gettype($maxChildAge)), __LINE__);
        }
        $this->MaxChildAge = $maxChildAge;
        return $this;
    }
    /**
     * Get BaseMealPlan value
     * @return string|null
     */
    public function getBaseMealPlan()
    {
        return $this->BaseMealPlan;
    }
    /**
     * Set BaseMealPlan value
     * @param string $baseMealPlan
     * @return \StructType\AccommodationInfoType
     */
    public function setBaseMealPlan($baseMealPlan = null)
    {
        // validation for constraint: string
        if (!is_null($baseMealPlan) && !is_string($baseMealPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseMealPlan, true), gettype($baseMealPlan)), __LINE__);
        }
        $this->BaseMealPlan = $baseMealPlan;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccommodationInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
