<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccommodationDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: Detail about a space or place that is occupied by a passenger, such as seat, berth, and compartment, including specific information such as seat number, seat position, compartment number, seat direction, etc.
 * @subpackage Structs
 */
class AccommodationDetail extends RailAccommDetailType
{
    /**
     * The ReferenceTravelerRPH
     * Meta information extracted from the WSDL
     * - documentation: If specified, indicates this traveler requested a seat or berth adjacent to the traveler in the same reservation request, which is identified by the specified Reference Traveler RPH.
     * - use: optional
     * @var string
     */
    public $ReferenceTravelerRPH;
    /**
     * The ReferenceInd
     * Meta information extracted from the WSDL
     * - documentation: If true, indicates a request for an accommodation (seat/berth/compartment) adjacent to a specified reference accommodation.
     * - use: optional
     * @var bool
     */
    public $ReferenceInd;
    /**
     * Constructor method for AccommodationDetail
     * @uses AccommodationDetail::setReferenceTravelerRPH()
     * @uses AccommodationDetail::setReferenceInd()
     * @param string $referenceTravelerRPH
     * @param bool $referenceInd
     */
    public function __construct($referenceTravelerRPH = null, $referenceInd = null)
    {
        $this
            ->setReferenceTravelerRPH($referenceTravelerRPH)
            ->setReferenceInd($referenceInd);
    }
    /**
     * Get ReferenceTravelerRPH value
     * @return string|null
     */
    public function getReferenceTravelerRPH()
    {
        return $this->ReferenceTravelerRPH;
    }
    /**
     * Set ReferenceTravelerRPH value
     * @param string $referenceTravelerRPH
     * @return \StructType\AccommodationDetail
     */
    public function setReferenceTravelerRPH($referenceTravelerRPH = null)
    {
        // validation for constraint: string
        if (!is_null($referenceTravelerRPH) && !is_string($referenceTravelerRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceTravelerRPH, true), gettype($referenceTravelerRPH)), __LINE__);
        }
        $this->ReferenceTravelerRPH = $referenceTravelerRPH;
        return $this;
    }
    /**
     * Get ReferenceInd value
     * @return bool|null
     */
    public function getReferenceInd()
    {
        return $this->ReferenceInd;
    }
    /**
     * Set ReferenceInd value
     * @param bool $referenceInd
     * @return \StructType\AccommodationDetail
     */
    public function setReferenceInd($referenceInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($referenceInd) && !is_bool($referenceInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($referenceInd, true), gettype($referenceInd)), __LINE__);
        }
        $this->ReferenceInd = $referenceInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccommodationDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
