<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccommodationCategoryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Any service or product offered in conjunction with a basic rail accommodation, such as vehicle transport, pet transport and restaurant car service. Refer to OpenTravel Code List Rail Ancillary Service (RAN). | Accommodations and
 * services offered on a train.
 * @subpackage Structs
 */
class AccommodationCategoryType extends AbstractStructBase
{
    /**
     * The Accommodation
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Accommodation[]
     */
    public $Accommodation;
    /**
     * The AncillaryService
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * - ref: AncillaryService
     * @var \StructType\AncillaryService[]
     */
    public $AncillaryService;
    /**
     * Constructor method for AccommodationCategoryType
     * @uses AccommodationCategoryType::setAccommodation()
     * @uses AccommodationCategoryType::setAncillaryService()
     * @param \StructType\Accommodation[] $accommodation
     * @param \StructType\AncillaryService[] $ancillaryService
     */
    public function __construct(array $accommodation = array(), array $ancillaryService = array())
    {
        $this
            ->setAccommodation($accommodation)
            ->setAncillaryService($ancillaryService);
    }
    /**
     * Get Accommodation value
     * @return \StructType\Accommodation[]|null
     */
    public function getAccommodation()
    {
        return $this->Accommodation;
    }
    /**
     * This method is responsible for validating the values passed to the setAccommodation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccommodation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccommodationForArrayConstraintsFromSetAccommodation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accommodationCategoryTypeAccommodationItem) {
            // validation for constraint: itemType
            if (!$accommodationCategoryTypeAccommodationItem instanceof \StructType\Accommodation) {
                $invalidValues[] = is_object($accommodationCategoryTypeAccommodationItem) ? get_class($accommodationCategoryTypeAccommodationItem) : sprintf('%s(%s)', gettype($accommodationCategoryTypeAccommodationItem), var_export($accommodationCategoryTypeAccommodationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Accommodation property can only contain items of type \StructType\Accommodation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Accommodation value
     * @throws \InvalidArgumentException
     * @param \StructType\Accommodation[] $accommodation
     * @return \StructType\AccommodationCategoryType
     */
    public function setAccommodation(array $accommodation = array())
    {
        // validation for constraint: array
        if ('' !== ($accommodationArrayErrorMessage = self::validateAccommodationForArrayConstraintsFromSetAccommodation($accommodation))) {
            throw new \InvalidArgumentException($accommodationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($accommodation) && count($accommodation) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($accommodation)), __LINE__);
        }
        $this->Accommodation = $accommodation;
        return $this;
    }
    /**
     * Add item to Accommodation value
     * @throws \InvalidArgumentException
     * @param \StructType\Accommodation $item
     * @return \StructType\AccommodationCategoryType
     */
    public function addToAccommodation(\StructType\Accommodation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accommodation) {
            throw new \InvalidArgumentException(sprintf('The Accommodation property can only contain items of type \StructType\Accommodation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Accommodation) && count($this->Accommodation) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Accommodation)), __LINE__);
        }
        $this->Accommodation[] = $item;
        return $this;
    }
    /**
     * Get AncillaryService value
     * @return \StructType\AncillaryService[]|null
     */
    public function getAncillaryService()
    {
        return $this->AncillaryService;
    }
    /**
     * This method is responsible for validating the values passed to the setAncillaryService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAncillaryService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAncillaryServiceForArrayConstraintsFromSetAncillaryService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accommodationCategoryTypeAncillaryServiceItem) {
            // validation for constraint: itemType
            if (!$accommodationCategoryTypeAncillaryServiceItem instanceof \StructType\AncillaryService) {
                $invalidValues[] = is_object($accommodationCategoryTypeAncillaryServiceItem) ? get_class($accommodationCategoryTypeAncillaryServiceItem) : sprintf('%s(%s)', gettype($accommodationCategoryTypeAncillaryServiceItem), var_export($accommodationCategoryTypeAncillaryServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AncillaryService property can only contain items of type \StructType\AncillaryService, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AncillaryService value
     * @throws \InvalidArgumentException
     * @param \StructType\AncillaryService[] $ancillaryService
     * @return \StructType\AccommodationCategoryType
     */
    public function setAncillaryService(array $ancillaryService = array())
    {
        // validation for constraint: array
        if ('' !== ($ancillaryServiceArrayErrorMessage = self::validateAncillaryServiceForArrayConstraintsFromSetAncillaryService($ancillaryService))) {
            throw new \InvalidArgumentException($ancillaryServiceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($ancillaryService) && count($ancillaryService) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($ancillaryService)), __LINE__);
        }
        $this->AncillaryService = $ancillaryService;
        return $this;
    }
    /**
     * Add item to AncillaryService value
     * @throws \InvalidArgumentException
     * @param \StructType\AncillaryService $item
     * @return \StructType\AccommodationCategoryType
     */
    public function addToAncillaryService(\StructType\AncillaryService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AncillaryService) {
            throw new \InvalidArgumentException(sprintf('The AncillaryService property can only contain items of type \StructType\AncillaryService, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->AncillaryService) && count($this->AncillaryService) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->AncillaryService)), __LINE__);
        }
        $this->AncillaryService[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccommodationCategoryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
