<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccommodationCategoryBaseType StructType
 * Meta information extracted from the WSDL
 * - documentation: A choice between a seat or berth accommodation. | The category of accommodation on a train.
 * @subpackage Structs
 */
class AccommodationCategoryBaseType extends AbstractStructBase
{
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - documentation: The seat type, such as Seat and Sleeperette.
     * - choice: Seat | Berth
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var mixed
     */
    public $Seat;
    /**
     * The Berth
     * Meta information extracted from the WSDL
     * - documentation: The berth type, such as Sleeper and Couchette.
     * - choice: Seat | Berth
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var mixed
     */
    public $Berth;
    /**
     * The Class
     * Meta information extracted from the WSDL
     * - documentation: The accommodation class, such as First Class and Second Class.
     * - minOccurs: 0
     * @var mixed
     */
    public $Class;
    /**
     * The Compartment
     * Meta information extracted from the WSDL
     * - documentation: The compartment type, such as Family and Single.
     * - minOccurs: 0
     * @var mixed
     */
    public $Compartment;
    /**
     * Constructor method for AccommodationCategoryBaseType
     * @uses AccommodationCategoryBaseType::setSeat()
     * @uses AccommodationCategoryBaseType::setBerth()
     * @uses AccommodationCategoryBaseType::setClass()
     * @uses AccommodationCategoryBaseType::setCompartment()
     * @param mixed $seat
     * @param mixed $berth
     * @param mixed $class
     * @param mixed $compartment
     */
    public function __construct($seat = null, $berth = null, $class = null, $compartment = null)
    {
        $this
            ->setSeat($seat)
            ->setBerth($berth)
            ->setClass($class)
            ->setCompartment($compartment);
    }
    /**
     * Get Seat value
     * @return mixed|null
     */
    public function getSeat()
    {
        return isset($this->Seat) ? $this->Seat : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSeat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeat method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSeatForChoiceConstraintsFromSetSeat($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Berth',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Seat can\'t be set as the property %s is already set. Only one property must be set among these properties: Seat, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Seat value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $seat
     * @return \StructType\AccommodationCategoryBaseType
     */
    public function setSeat($seat = null)
    {
        // validation for constraint: choice(Seat, Berth)
        if ('' !== ($seatChoiceErrorMessage = self::validateSeatForChoiceConstraintsFromSetSeat($seat))) {
            throw new \InvalidArgumentException($seatChoiceErrorMessage, __LINE__);
        }
        if (is_null($seat) || (is_array($seat) && empty($seat))) {
            unset($this->Seat);
        } else {
            $this->Seat = $seat;
        }
        return $this;
    }
    /**
     * Get Berth value
     * @return mixed|null
     */
    public function getBerth()
    {
        return isset($this->Berth) ? $this->Berth : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBerth method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBerth method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBerthForChoiceConstraintsFromSetBerth($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Seat',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Berth can\'t be set as the property %s is already set. Only one property must be set among these properties: Berth, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Berth value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $berth
     * @return \StructType\AccommodationCategoryBaseType
     */
    public function setBerth($berth = null)
    {
        // validation for constraint: choice(Seat, Berth)
        if ('' !== ($berthChoiceErrorMessage = self::validateBerthForChoiceConstraintsFromSetBerth($berth))) {
            throw new \InvalidArgumentException($berthChoiceErrorMessage, __LINE__);
        }
        if (is_null($berth) || (is_array($berth) && empty($berth))) {
            unset($this->Berth);
        } else {
            $this->Berth = $berth;
        }
        return $this;
    }
    /**
     * Get Class value
     * @return mixed|null
     */
    public function getClass()
    {
        return $this->Class;
    }
    /**
     * Set Class value
     * @param mixed $class
     * @return \StructType\AccommodationCategoryBaseType
     */
    public function setClass($class = null)
    {
        $this->Class = $class;
        return $this;
    }
    /**
     * Get Compartment value
     * @return mixed|null
     */
    public function getCompartment()
    {
        return $this->Compartment;
    }
    /**
     * Set Compartment value
     * @param mixed $compartment
     * @return \StructType\AccommodationCategoryBaseType
     */
    public function setCompartment($compartment = null)
    {
        $this->Compartment = $compartment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccommodationCategoryBaseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
