<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptedPaymentsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to define the types of payments accepted.
 * @subpackage Structs
 */
class AcceptedPaymentsType extends AbstractStructBase
{
    /**
     * The AcceptedPayment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AcceptedPayment[]
     */
    public $AcceptedPayment;
    /**
     * Constructor method for AcceptedPaymentsType
     * @uses AcceptedPaymentsType::setAcceptedPayment()
     * @param \StructType\AcceptedPayment[] $acceptedPayment
     */
    public function __construct(array $acceptedPayment = array())
    {
        $this
            ->setAcceptedPayment($acceptedPayment);
    }
    /**
     * Get AcceptedPayment value
     * @return \StructType\AcceptedPayment[]|null
     */
    public function getAcceptedPayment()
    {
        return $this->AcceptedPayment;
    }
    /**
     * This method is responsible for validating the values passed to the setAcceptedPayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcceptedPayment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAcceptedPaymentForArrayConstraintsFromSetAcceptedPayment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $acceptedPaymentsTypeAcceptedPaymentItem) {
            // validation for constraint: itemType
            if (!$acceptedPaymentsTypeAcceptedPaymentItem instanceof \StructType\AcceptedPayment) {
                $invalidValues[] = is_object($acceptedPaymentsTypeAcceptedPaymentItem) ? get_class($acceptedPaymentsTypeAcceptedPaymentItem) : sprintf('%s(%s)', gettype($acceptedPaymentsTypeAcceptedPaymentItem), var_export($acceptedPaymentsTypeAcceptedPaymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AcceptedPayment property can only contain items of type \StructType\AcceptedPayment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AcceptedPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptedPayment[] $acceptedPayment
     * @return \StructType\AcceptedPaymentsType
     */
    public function setAcceptedPayment(array $acceptedPayment = array())
    {
        // validation for constraint: array
        if ('' !== ($acceptedPaymentArrayErrorMessage = self::validateAcceptedPaymentForArrayConstraintsFromSetAcceptedPayment($acceptedPayment))) {
            throw new \InvalidArgumentException($acceptedPaymentArrayErrorMessage, __LINE__);
        }
        $this->AcceptedPayment = $acceptedPayment;
        return $this;
    }
    /**
     * Add item to AcceptedPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptedPayment $item
     * @return \StructType\AcceptedPaymentsType
     */
    public function addToAcceptedPayment(\StructType\AcceptedPayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AcceptedPayment) {
            throw new \InvalidArgumentException(sprintf('The AcceptedPayment property can only contain items of type \StructType\AcceptedPayment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AcceptedPayment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AcceptedPaymentsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
