<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptablePaymentCards StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of payment cards that are acceptable as a form of payment.
 * @subpackage Structs
 */
class AcceptablePaymentCards extends AbstractStructBase
{
    /**
     * The AcceptablePaymentCard
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\AcceptablePaymentCard[]
     */
    public $AcceptablePaymentCard;
    /**
     * Constructor method for AcceptablePaymentCards
     * @uses AcceptablePaymentCards::setAcceptablePaymentCard()
     * @param \StructType\AcceptablePaymentCard[] $acceptablePaymentCard
     */
    public function __construct(array $acceptablePaymentCard = array())
    {
        $this
            ->setAcceptablePaymentCard($acceptablePaymentCard);
    }
    /**
     * Get AcceptablePaymentCard value
     * @return \StructType\AcceptablePaymentCard[]|null
     */
    public function getAcceptablePaymentCard()
    {
        return $this->AcceptablePaymentCard;
    }
    /**
     * This method is responsible for validating the values passed to the setAcceptablePaymentCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcceptablePaymentCard method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAcceptablePaymentCardForArrayConstraintsFromSetAcceptablePaymentCard(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $acceptablePaymentCardsAcceptablePaymentCardItem) {
            // validation for constraint: itemType
            if (!$acceptablePaymentCardsAcceptablePaymentCardItem instanceof \StructType\AcceptablePaymentCard) {
                $invalidValues[] = is_object($acceptablePaymentCardsAcceptablePaymentCardItem) ? get_class($acceptablePaymentCardsAcceptablePaymentCardItem) : sprintf('%s(%s)', gettype($acceptablePaymentCardsAcceptablePaymentCardItem), var_export($acceptablePaymentCardsAcceptablePaymentCardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AcceptablePaymentCard property can only contain items of type \StructType\AcceptablePaymentCard, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AcceptablePaymentCard value
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptablePaymentCard[] $acceptablePaymentCard
     * @return \StructType\AcceptablePaymentCards
     */
    public function setAcceptablePaymentCard(array $acceptablePaymentCard = array())
    {
        // validation for constraint: array
        if ('' !== ($acceptablePaymentCardArrayErrorMessage = self::validateAcceptablePaymentCardForArrayConstraintsFromSetAcceptablePaymentCard($acceptablePaymentCard))) {
            throw new \InvalidArgumentException($acceptablePaymentCardArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($acceptablePaymentCard) && count($acceptablePaymentCard) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($acceptablePaymentCard)), __LINE__);
        }
        $this->AcceptablePaymentCard = $acceptablePaymentCard;
        return $this;
    }
    /**
     * Add item to AcceptablePaymentCard value
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptablePaymentCard $item
     * @return \StructType\AcceptablePaymentCards
     */
    public function addToAcceptablePaymentCard(\StructType\AcceptablePaymentCard $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AcceptablePaymentCard) {
            throw new \InvalidArgumentException(sprintf('The AcceptablePaymentCard property can only contain items of type \StructType\AcceptablePaymentCard, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->AcceptablePaymentCard) && count($this->AcceptablePaymentCard) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->AcceptablePaymentCard)), __LINE__);
        }
        $this->AcceptablePaymentCard[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AcceptablePaymentCards
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
