<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for OTAR ServiceType
 * @subpackage Services
 */
class OTAR extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OTA_Read
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_ReadRQ $readRQ_msg
     * @return \StructType\OTA_ResRetrieveRS|bool
     */
    public function OTA_Read(\StructType\OTA_ReadRQ $readRQ_msg)
    {
        try {
            $this->setResult($this->getSoapClient()->OTA_Read($readRQ_msg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OTA_ResRetrieveRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
