<?php

namespace EnumType;

/**
 * This class stands for Usage EnumType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the usage of the passenger fare structure. | Used to specify how the discount is to be applied.
 * @subpackage Enumerations
 */
class Usage
{
    /**
     * Constant for value 'Plus'
     * @return string 'Plus'
     */
    const VALUE_PLUS = 'Plus';
    /**
     * Constant for value 'Minus'
     * @return string 'Minus'
     */
    const VALUE_MINUS = 'Minus';
    /**
     * Constant for value 'PassengerFare'
     * @return string 'PassengerFare'
     */
    const VALUE_PASSENGER_FARE = 'PassengerFare';
    /**
     * Constant for value 'TicketFee'
     * @return string 'TicketFee'
     */
    const VALUE_TICKET_FEE = 'TicketFee';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PLUS
     * @uses self::VALUE_MINUS
     * @uses self::VALUE_PASSENGER_FARE
     * @uses self::VALUE_TICKET_FEE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PLUS,
            self::VALUE_MINUS,
            self::VALUE_PASSENGER_FARE,
            self::VALUE_TICKET_FEE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
