<?php

namespace EnumType;

/**
 * This class stands for Type EnumType
 * Meta information extracted from the WSDL
 * - documentation: Used to specify the location requirement type affecting the pricing. | The type of seat in the seat zone, e.g. premium, non-premium and seats with features. | A type of seat in the seat zone being requested, e.g. premium, non-premium
 * and seats with features. | The type of fare date, including historic and last ticketing. | Specifies the type of date. | The waiver type. | Used to indicate a ticket or EMD. | Specifies the type of amount being sent. | Used to specify whether the
 * payment information is for guaranteeing the rental or is the actual form of payment. | The type of checkout. | Indicates whether the flight is a scheduled or charter service. | Indicates whether the DurationPeriod is a 'Base' (i.e.. a charge for one
 * of a tier of durations like 3days, 7days etc.) or 'AddOn' (i.e. for periods extending a base period like extra day, extra week etc.) | Indicates whether the Location is for Pickup, DropOff or Both. | An enumerated list of offer sources. | Defines how
 * the cancellation penalty will be applied. | Used to specify the type of information being sent (i.e., RequiredPayment, GuaranteePolicy, AcceptedPaymentForms). | To specify if the charge applies to early or late checkout. | Values: Before Arrival,
 * After Booking. | An enumerated type indicating when the drop time goes into effect.
 * @subpackage Enumerations
 */
class Type
{
    /**
     * Constant for value 'BeforeArrival'
     * @return string 'BeforeArrival'
     */
    const VALUE_BEFORE_ARRIVAL = 'BeforeArrival';
    /**
     * Constant for value 'AfterBooking'
     * @return string 'AfterBooking'
     */
    const VALUE_AFTER_BOOKING = 'AfterBooking';
    /**
     * Constant for value 'Early'
     * @return string 'Early'
     */
    const VALUE_EARLY = 'Early';
    /**
     * Constant for value 'Late'
     * @return string 'Late'
     */
    const VALUE_LATE = 'Late';
    /**
     * Constant for value 'RequiredPayment'
     * @return string 'RequiredPayment'
     */
    const VALUE_REQUIRED_PAYMENT = 'RequiredPayment';
    /**
     * Constant for value 'GuaranteePolicy'
     * @return string 'GuaranteePolicy'
     */
    const VALUE_GUARANTEE_POLICY = 'GuaranteePolicy';
    /**
     * Constant for value 'AcceptedPaymentForms'
     * @return string 'AcceptedPaymentForms'
     */
    const VALUE_ACCEPTED_PAYMENT_FORMS = 'AcceptedPaymentForms';
    /**
     * Constant for value 'Refund'
     * @return string 'Refund'
     */
    const VALUE_REFUND = 'Refund';
    /**
     * Constant for value 'Charge'
     * @return string 'Charge'
     */
    const VALUE_CHARGE = 'Charge';
    /**
     * Constant for value 'Forfeiture'
     * @return string 'Forfeiture'
     */
    const VALUE_FORFEITURE = 'Forfeiture';
    /**
     * Constant for value 'Partner'
     * @return string 'Partner'
     */
    const VALUE_PARTNER = 'Partner';
    /**
     * Constant for value 'Loyalty'
     * @return string 'Loyalty'
     */
    const VALUE_LOYALTY = 'Loyalty';
    /**
     * Constant for value 'PickUp'
     * @return string 'PickUp'
     */
    const VALUE_PICK_UP = 'PickUp';
    /**
     * Constant for value 'DropOff'
     * @return string 'DropOff'
     */
    const VALUE_DROP_OFF = 'DropOff';
    /**
     * Constant for value 'Both'
     * @return string 'Both'
     */
    const VALUE_BOTH = 'Both';
    /**
     * Constant for value 'Base'
     * @return string 'Base'
     */
    const VALUE_BASE = 'Base';
    /**
     * Constant for value 'AddOn'
     * @return string 'AddOn'
     */
    const VALUE_ADD_ON = 'AddOn';
    /**
     * Constant for value 'Charter'
     * @return string 'Charter'
     */
    const VALUE_CHARTER = 'Charter';
    /**
     * Constant for value 'Scheduled'
     * @return string 'Scheduled'
     */
    const VALUE_SCHEDULED = 'Scheduled';
    /**
     * Constant for value 'guarantee'
     * @return string 'guarantee'
     */
    const VALUE_GUARANTEE = 'guarantee';
    /**
     * Constant for value 'payment'
     * @return string 'payment'
     */
    const VALUE_PAYMENT = 'payment';
    /**
     * Constant for value 'Amount'
     * @return string 'Amount'
     */
    const VALUE_AMOUNT = 'Amount';
    /**
     * Constant for value 'Percent'
     * @return string 'Percent'
     */
    const VALUE_PERCENT = 'Percent';
    /**
     * Constant for value 'PlusUpAmount'
     * @return string 'PlusUpAmount'
     */
    const VALUE_PLUS_UP_AMOUNT = 'PlusUpAmount';
    /**
     * Constant for value 'Ticket'
     * @return string 'Ticket'
     */
    const VALUE_TICKET = 'Ticket';
    /**
     * Constant for value 'EMD'
     * @return string 'EMD'
     */
    const VALUE_EMD = 'EMD';
    /**
     * Constant for value 'ExchangedReissued'
     * @return string 'ExchangedReissued'
     */
    const VALUE_EXCHANGED_REISSUED = 'ExchangedReissued';
    /**
     * Constant for value 'FareComponent'
     * @return string 'FareComponent'
     */
    const VALUE_FARE_COMPONENT = 'FareComponent';
    /**
     * Constant for value 'LastRuleChange'
     * @return string 'LastRuleChange'
     */
    const VALUE_LAST_RULE_CHANGE = 'LastRuleChange';
    /**
     * Constant for value 'RuleBecomesInvalid'
     * @return string 'RuleBecomesInvalid'
     */
    const VALUE_RULE_BECOMES_INVALID = 'RuleBecomesInvalid';
    /**
     * Constant for value 'RestrictiveFareEffective'
     * @return string 'RestrictiveFareEffective'
     */
    const VALUE_RESTRICTIVE_FARE_EFFECTIVE = 'RestrictiveFareEffective';
    /**
     * Constant for value 'RestrictiveFareDiscontinue'
     * @return string 'RestrictiveFareDiscontinue'
     */
    const VALUE_RESTRICTIVE_FARE_DISCONTINUE = 'RestrictiveFareDiscontinue';
    /**
     * Constant for value 'EffectiveTravel'
     * @return string 'EffectiveTravel'
     */
    const VALUE_EFFECTIVE_TRAVEL = 'EffectiveTravel';
    /**
     * Constant for value 'DiscontinueTravel'
     * @return string 'DiscontinueTravel'
     */
    const VALUE_DISCONTINUE_TRAVEL = 'DiscontinueTravel';
    /**
     * Constant for value 'FirstTicketing'
     * @return string 'FirstTicketing'
     */
    const VALUE_FIRST_TICKETING = 'FirstTicketing';
    /**
     * Constant for value 'LastTicketing'
     * @return string 'LastTicketing'
     */
    const VALUE_LAST_TICKETING = 'LastTicketing';
    /**
     * Constant for value 'TravelCompletion'
     * @return string 'TravelCompletion'
     */
    const VALUE_TRAVEL_COMPLETION = 'TravelCompletion';
    /**
     * Constant for value 'Historic'
     * @return string 'Historic'
     */
    const VALUE_HISTORIC = 'Historic';
    /**
     * Constant for value 'Tax'
     * @return string 'Tax'
     */
    const VALUE_TAX = 'Tax';
    /**
     * Constant for value 'Total'
     * @return string 'Total'
     */
    const VALUE_TOTAL = 'Total';
    /**
     * Constant for value 'NonPremium'
     * @return string 'NonPremium'
     */
    const VALUE_NON_PREMIUM = 'NonPremium';
    /**
     * Constant for value 'Premium'
     * @return string 'Premium'
     */
    const VALUE_PREMIUM = 'Premium';
    /**
     * Constant for value 'SeatWithFeatures'
     * @return string 'SeatWithFeatures'
     */
    const VALUE_SEAT_WITH_FEATURES = 'SeatWithFeatures';
    /**
     * Constant for value 'LocalEmployee'
     * @return string 'LocalEmployee'
     */
    const VALUE_LOCAL_EMPLOYEE = 'LocalEmployee';
    /**
     * Constant for value 'LocalResident'
     * @return string 'LocalResident'
     */
    const VALUE_LOCAL_RESIDENT = 'LocalResident';
    /**
     * Constant for value 'LocalNationalityShipReg'
     * @return string 'LocalNationalityShipReg'
     */
    const VALUE_LOCAL_NATIONALITY_SHIP_REG = 'LocalNationalityShipReg';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BEFORE_ARRIVAL
     * @uses self::VALUE_AFTER_BOOKING
     * @uses self::VALUE_EARLY
     * @uses self::VALUE_LATE
     * @uses self::VALUE_REQUIRED_PAYMENT
     * @uses self::VALUE_GUARANTEE_POLICY
     * @uses self::VALUE_ACCEPTED_PAYMENT_FORMS
     * @uses self::VALUE_REFUND
     * @uses self::VALUE_CHARGE
     * @uses self::VALUE_FORFEITURE
     * @uses self::VALUE_PARTNER
     * @uses self::VALUE_LOYALTY
     * @uses self::VALUE_PICK_UP
     * @uses self::VALUE_DROP_OFF
     * @uses self::VALUE_BOTH
     * @uses self::VALUE_BASE
     * @uses self::VALUE_ADD_ON
     * @uses self::VALUE_CHARTER
     * @uses self::VALUE_SCHEDULED
     * @uses self::VALUE_GUARANTEE
     * @uses self::VALUE_PAYMENT
     * @uses self::VALUE_AMOUNT
     * @uses self::VALUE_PERCENT
     * @uses self::VALUE_PLUS_UP_AMOUNT
     * @uses self::VALUE_TICKET
     * @uses self::VALUE_EMD
     * @uses self::VALUE_EXCHANGED_REISSUED
     * @uses self::VALUE_FARE_COMPONENT
     * @uses self::VALUE_LAST_RULE_CHANGE
     * @uses self::VALUE_RULE_BECOMES_INVALID
     * @uses self::VALUE_RESTRICTIVE_FARE_EFFECTIVE
     * @uses self::VALUE_RESTRICTIVE_FARE_DISCONTINUE
     * @uses self::VALUE_EFFECTIVE_TRAVEL
     * @uses self::VALUE_DISCONTINUE_TRAVEL
     * @uses self::VALUE_FIRST_TICKETING
     * @uses self::VALUE_LAST_TICKETING
     * @uses self::VALUE_TRAVEL_COMPLETION
     * @uses self::VALUE_HISTORIC
     * @uses self::VALUE_TAX
     * @uses self::VALUE_TOTAL
     * @uses self::VALUE_NON_PREMIUM
     * @uses self::VALUE_PREMIUM
     * @uses self::VALUE_SEAT_WITH_FEATURES
     * @uses self::VALUE_LOCAL_EMPLOYEE
     * @uses self::VALUE_LOCAL_RESIDENT
     * @uses self::VALUE_LOCAL_NATIONALITY_SHIP_REG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BEFORE_ARRIVAL,
            self::VALUE_AFTER_BOOKING,
            self::VALUE_EARLY,
            self::VALUE_LATE,
            self::VALUE_REQUIRED_PAYMENT,
            self::VALUE_GUARANTEE_POLICY,
            self::VALUE_ACCEPTED_PAYMENT_FORMS,
            self::VALUE_REFUND,
            self::VALUE_CHARGE,
            self::VALUE_FORFEITURE,
            self::VALUE_PARTNER,
            self::VALUE_LOYALTY,
            self::VALUE_PICK_UP,
            self::VALUE_DROP_OFF,
            self::VALUE_BOTH,
            self::VALUE_BASE,
            self::VALUE_ADD_ON,
            self::VALUE_CHARTER,
            self::VALUE_SCHEDULED,
            self::VALUE_GUARANTEE,
            self::VALUE_PAYMENT,
            self::VALUE_AMOUNT,
            self::VALUE_PERCENT,
            self::VALUE_PLUS_UP_AMOUNT,
            self::VALUE_TICKET,
            self::VALUE_EMD,
            self::VALUE_EXCHANGED_REISSUED,
            self::VALUE_FARE_COMPONENT,
            self::VALUE_LAST_RULE_CHANGE,
            self::VALUE_RULE_BECOMES_INVALID,
            self::VALUE_RESTRICTIVE_FARE_EFFECTIVE,
            self::VALUE_RESTRICTIVE_FARE_DISCONTINUE,
            self::VALUE_EFFECTIVE_TRAVEL,
            self::VALUE_DISCONTINUE_TRAVEL,
            self::VALUE_FIRST_TICKETING,
            self::VALUE_LAST_TICKETING,
            self::VALUE_TRAVEL_COMPLETION,
            self::VALUE_HISTORIC,
            self::VALUE_TAX,
            self::VALUE_TOTAL,
            self::VALUE_NON_PREMIUM,
            self::VALUE_PREMIUM,
            self::VALUE_SEAT_WITH_FEATURES,
            self::VALUE_LOCAL_EMPLOYEE,
            self::VALUE_LOCAL_RESIDENT,
            self::VALUE_LOCAL_NATIONALITY_SHIP_REG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
