<?php

namespace EnumType;

/**
 * This class stands for TripPurpose EnumType
 * Meta information extracted from the WSDL
 * - documentation: The purpose of the trip. If the customer has a default trip purpose this should be pre-populated with that value and the @TripPurposeRequiredInd should be set to FALSE.
 * @subpackage Enumerations
 */
class TripPurpose
{
    /**
     * Constant for value 'Business'
     * @return string 'Business'
     */
    const VALUE_BUSINESS = 'Business';
    /**
     * Constant for value 'BusinessAndPleasure'
     * @return string 'BusinessAndPleasure'
     */
    const VALUE_BUSINESS_AND_PLEASURE = 'BusinessAndPleasure';
    /**
     * Constant for value 'Pleasure'
     * @return string 'Pleasure'
     */
    const VALUE_PLEASURE = 'Pleasure';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BUSINESS
     * @uses self::VALUE_BUSINESS_AND_PLEASURE
     * @uses self::VALUE_PLEASURE
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BUSINESS,
            self::VALUE_BUSINESS_AND_PLEASURE,
            self::VALUE_PLEASURE,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
