<?php

namespace EnumType;

/**
 * This class stands for TravelPurposeEnum EnumType
 * Meta information extracted from the WSDL
 * - documentation: The purpose of travel
 * @subpackage Enumerations
 */
class TravelPurposeEnum
{
    /**
     * Constant for value 'NotSignificant'
     * @return string 'NotSignificant'
     */
    const VALUE_NOT_SIGNIFICANT = 'NotSignificant';
    /**
     * Constant for value 'Business'
     * @return string 'Business'
     */
    const VALUE_BUSINESS = 'Business';
    /**
     * Constant for value 'Personal'
     * @return string 'Personal'
     */
    const VALUE_PERSONAL = 'Personal';
    /**
     * Constant for value 'Group'
     * @return string 'Group'
     */
    const VALUE_GROUP = 'Group';
    /**
     * Constant for value 'Conference'
     * @return string 'Conference'
     */
    const VALUE_CONFERENCE = 'Conference';
    /**
     * Constant for value 'Consortiums'
     * @return string 'Consortiums'
     */
    const VALUE_CONSORTIUMS = 'Consortiums';
    /**
     * Constant for value 'HomeVisiting'
     * @return string 'HomeVisiting'
     */
    const VALUE_HOME_VISITING = 'HomeVisiting';
    /**
     * Constant for value 'Other_'
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SIGNIFICANT
     * @uses self::VALUE_BUSINESS
     * @uses self::VALUE_PERSONAL
     * @uses self::VALUE_GROUP
     * @uses self::VALUE_CONFERENCE
     * @uses self::VALUE_CONSORTIUMS
     * @uses self::VALUE_HOME_VISITING
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SIGNIFICANT,
            self::VALUE_BUSINESS,
            self::VALUE_PERSONAL,
            self::VALUE_GROUP,
            self::VALUE_CONFERENCE,
            self::VALUE_CONSORTIUMS,
            self::VALUE_HOME_VISITING,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
