<?php

namespace EnumType;

/**
 * This class stands for Status EnumType
 * Meta information extracted from the WSDL
 * - documentation: The status of the product. This attribute would primarily be used in the response message to identify the status of the item being purchased.
 * @subpackage Enumerations
 */
class Status
{
    /**
     * Constant for value 'OrderPending'
     * @return string 'OrderPending'
     */
    const VALUE_ORDER_PENDING = 'OrderPending';
    /**
     * Constant for value 'BackOrder'
     * @return string 'BackOrder'
     */
    const VALUE_BACK_ORDER = 'BackOrder';
    /**
     * Constant for value 'Unavailable'
     * @return string 'Unavailable'
     */
    const VALUE_UNAVAILABLE = 'Unavailable';
    /**
     * Constant for value 'Confirmed'
     * @return string 'Confirmed'
     */
    const VALUE_CONFIRMED = 'Confirmed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ORDER_PENDING
     * @uses self::VALUE_BACK_ORDER
     * @uses self::VALUE_UNAVAILABLE
     * @uses self::VALUE_CONFIRMED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ORDER_PENDING,
            self::VALUE_BACK_ORDER,
            self::VALUE_UNAVAILABLE,
            self::VALUE_CONFIRMED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
