<?php

namespace EnumType;

/**
 * This class stands for SeatPositionType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the position of a seat, such as Window and Aisle.
 * @subpackage Enumerations
 */
class SeatPositionType
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Together'
     * @return string 'Together'
     */
    const VALUE_TOGETHER = 'Together';
    /**
     * Constant for value 'Aisle'
     * @return string 'Aisle'
     */
    const VALUE_AISLE = 'Aisle';
    /**
     * Constant for value 'Center'
     * @return string 'Center'
     */
    const VALUE_CENTER = 'Center';
    /**
     * Constant for value 'Window'
     * @return string 'Window'
     */
    const VALUE_WINDOW = 'Window';
    /**
     * Constant for value 'Specific'
     * @return string 'Specific'
     */
    const VALUE_SPECIFIC = 'Specific';
    /**
     * Constant for value 'Exit'
     * @return string 'Exit'
     */
    const VALUE_EXIT = 'Exit';
    /**
     * Constant for value 'Table'
     * @return string 'Table'
     */
    const VALUE_TABLE = 'Table';
    /**
     * Constant for value 'AdjacentAisle'
     * @return string 'AdjacentAisle'
     */
    const VALUE_ADJACENT_AISLE = 'AdjacentAisle';
    /**
     * Constant for value 'Individual'
     * @return string 'Individual'
     */
    const VALUE_INDIVIDUAL = 'Individual';
    /**
     * Constant for value 'Middle'
     * @return string 'Middle'
     */
    const VALUE_MIDDLE = 'Middle';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_TOGETHER
     * @uses self::VALUE_AISLE
     * @uses self::VALUE_CENTER
     * @uses self::VALUE_WINDOW
     * @uses self::VALUE_SPECIFIC
     * @uses self::VALUE_EXIT
     * @uses self::VALUE_TABLE
     * @uses self::VALUE_ADJACENT_AISLE
     * @uses self::VALUE_INDIVIDUAL
     * @uses self::VALUE_MIDDLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_TOGETHER,
            self::VALUE_AISLE,
            self::VALUE_CENTER,
            self::VALUE_WINDOW,
            self::VALUE_SPECIFIC,
            self::VALUE_EXIT,
            self::VALUE_TABLE,
            self::VALUE_ADJACENT_AISLE,
            self::VALUE_INDIVIDUAL,
            self::VALUE_MIDDLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
