<?php

namespace EnumType;

/**
 * This class stands for RateType EnumType
 * @subpackage Enumerations
 */
class RateType
{
    /**
     * Constant for value 'Rack'
     * @return string 'Rack'
     */
    const VALUE_RACK = 'Rack';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RACK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RACK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
