<?php

namespace EnumType;

/**
 * This class stands for PurposeType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Used to specify base, net, sell or refund amount.
 * @subpackage Enumerations
 */
class PurposeType
{
    /**
     * Constant for value 'Sell'
     * @return string 'Sell'
     */
    const VALUE_SELL = 'Sell';
    /**
     * Constant for value 'Net'
     * @return string 'Net'
     */
    const VALUE_NET = 'Net';
    /**
     * Constant for value 'Base'
     * @return string 'Base'
     */
    const VALUE_BASE = 'Base';
    /**
     * Constant for value 'Refund'
     * @return string 'Refund'
     */
    const VALUE_REFUND = 'Refund';
    /**
     * Constant for value 'Additional'
     * @return string 'Additional'
     */
    const VALUE_ADDITIONAL = 'Additional';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SELL
     * @uses self::VALUE_NET
     * @uses self::VALUE_BASE
     * @uses self::VALUE_REFUND
     * @uses self::VALUE_ADDITIONAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SELL,
            self::VALUE_NET,
            self::VALUE_BASE,
            self::VALUE_REFUND,
            self::VALUE_ADDITIONAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
