<?php

namespace EnumType;

/**
 * This class stands for Name EnumType
 * Meta information extracted from the WSDL
 * - documentation: The name of the policy.
 * @subpackage Enumerations
 */
class Name
{
    /**
     * Constant for value 'RestaurantPolicy'
     * @return string 'RestaurantPolicy'
     */
    const VALUE_RESTAURANT_POLICY = 'RestaurantPolicy';
    /**
     * Constant for value 'AdditionalOversoldPolicy'
     * @return string 'AdditionalOversoldPolicy'
     */
    const VALUE_ADDITIONAL_OVERSOLD_POLICY = 'AdditionalOversoldPolicy';
    /**
     * Constant for value 'EarlyCheckinAvailable'
     * @return string 'EarlyCheckinAvailable'
     */
    const VALUE_EARLY_CHECKIN_AVAILABLE = 'EarlyCheckinAvailable';
    /**
     * Constant for value 'LateCheckoutAvailable'
     * @return string 'LateCheckoutAvailable'
     */
    const VALUE_LATE_CHECKOUT_AVAILABLE = 'LateCheckoutAvailable';
    /**
     * Constant for value 'OversoldArrangeAccommodations'
     * @return string 'OversoldArrangeAccommodations'
     */
    const VALUE_OVERSOLD_ARRANGE_ACCOMMODATIONS = 'OversoldArrangeAccommodations';
    /**
     * Constant for value 'OversoldArrangeTransportation'
     * @return string 'OversoldArrangeTransportation'
     */
    const VALUE_OVERSOLD_ARRANGE_TRANSPORTATION = 'OversoldArrangeTransportation';
    /**
     * Constant for value 'OversoldNotifyContacts'
     * @return string 'OversoldNotifyContacts'
     */
    const VALUE_OVERSOLD_NOTIFY_CONTACTS = 'OversoldNotifyContacts';
    /**
     * Constant for value 'OversoldPayOneNightRoom'
     * @return string 'OversoldPayOneNightRoom'
     */
    const VALUE_OVERSOLD_PAY_ONE_NIGHT_ROOM = 'OversoldPayOneNightRoom';
    /**
     * Constant for value 'OversoldProvidePhonecall'
     * @return string 'OversoldProvidePhonecall'
     */
    const VALUE_OVERSOLD_PROVIDE_PHONECALL = 'OversoldProvidePhonecall';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RESTAURANT_POLICY
     * @uses self::VALUE_ADDITIONAL_OVERSOLD_POLICY
     * @uses self::VALUE_EARLY_CHECKIN_AVAILABLE
     * @uses self::VALUE_LATE_CHECKOUT_AVAILABLE
     * @uses self::VALUE_OVERSOLD_ARRANGE_ACCOMMODATIONS
     * @uses self::VALUE_OVERSOLD_ARRANGE_TRANSPORTATION
     * @uses self::VALUE_OVERSOLD_NOTIFY_CONTACTS
     * @uses self::VALUE_OVERSOLD_PAY_ONE_NIGHT_ROOM
     * @uses self::VALUE_OVERSOLD_PROVIDE_PHONECALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RESTAURANT_POLICY,
            self::VALUE_ADDITIONAL_OVERSOLD_POLICY,
            self::VALUE_EARLY_CHECKIN_AVAILABLE,
            self::VALUE_LATE_CHECKOUT_AVAILABLE,
            self::VALUE_OVERSOLD_ARRANGE_ACCOMMODATIONS,
            self::VALUE_OVERSOLD_ARRANGE_TRANSPORTATION,
            self::VALUE_OVERSOLD_NOTIFY_CONTACTS,
            self::VALUE_OVERSOLD_PAY_ONE_NIGHT_ROOM,
            self::VALUE_OVERSOLD_PROVIDE_PHONECALL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
