<?php

namespace EnumType;

/**
 * This class stands for MealServiceType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumerated List (Meal Code in brackets): Breakfast (B); Snack (S); Dinner (D); Hot Meal (H); Lunch (L); Refreshments (R); Complimentary Liquor (C); Meal (M); Liquor for Purchase (P); Food for Purchase (F); Cold Meal (O); No Meal
 * Service (-). Alternately, a String of Length 32 can be used if the above list does not suffice.
 * - union: string | StringLength1to32
 * @subpackage Enumerations
 */
class MealServiceType
{
    /**
     * Constant for value 'Breakfast'
     * Meta information extracted from the WSDL
     * - documentation: Identifies a breakfast meal service.
     * @return string 'Breakfast'
     */
    const VALUE_BREAKFAST = 'Breakfast';
    /**
     * Constant for value 'Snack'
     * Meta information extracted from the WSDL
     * - documentation: Identifies a snack meal service.
     * @return string 'Snack'
     */
    const VALUE_SNACK = 'Snack';
    /**
     * Constant for value 'Dinner'
     * Meta information extracted from the WSDL
     * - documentation: Identifies a dinner meal service.
     * @return string 'Dinner'
     */
    const VALUE_DINNER = 'Dinner';
    /**
     * Constant for value 'Hot Meal'
     * Meta information extracted from the WSDL
     * - documentation: Identifies a hot meal service.
     * @return string 'Hot Meal'
     */
    const VALUE_HOT_MEAL = 'Hot Meal';
    /**
     * Constant for value 'Lunch'
     * Meta information extracted from the WSDL
     * - documentation: Identifies a lunch meal service.
     * @return string 'Lunch'
     */
    const VALUE_LUNCH = 'Lunch';
    /**
     * Constant for value 'Refreshments'
     * Meta information extracted from the WSDL
     * - documentation: Identifies a refreshments meal service.
     * @return string 'Refreshments'
     */
    const VALUE_REFRESHMENTS = 'Refreshments';
    /**
     * Constant for value 'Complimentary Liquor'
     * Meta information extracted from the WSDL
     * - documentation: Identifies a complimentary liquor meal service.
     * @return string 'Complimentary Liquor'
     */
    const VALUE_COMPLIMENTARY_LIQUOR = 'Complimentary Liquor';
    /**
     * Constant for value 'Meal'
     * Meta information extracted from the WSDL
     * - documentation: Identifies a meal service exists.
     * @return string 'Meal'
     */
    const VALUE_MEAL = 'Meal';
    /**
     * Constant for value 'Liquor for Purchase'
     * Meta information extracted from the WSDL
     * - documentation: Identifies that liquor is available for purchase.
     * @return string 'Liquor for Purchase'
     */
    const VALUE_LIQUOR_FOR_PURCHASE = 'Liquor for Purchase';
    /**
     * Constant for value 'Food for Purchase'
     * Meta information extracted from the WSDL
     * - documentation: Identifies that food is available for purchase.
     * @return string 'Food for Purchase'
     */
    const VALUE_FOOD_FOR_PURCHASE = 'Food for Purchase';
    /**
     * Constant for value 'Cold Meal'
     * Meta information extracted from the WSDL
     * - documentation: Identifies a cold meal service is available.
     * @return string 'Cold Meal'
     */
    const VALUE_COLD_MEAL = 'Cold Meal';
    /**
     * Constant for value 'No Meal Service'
     * Meta information extracted from the WSDL
     * - documentation: Identifies that no meal service is available.
     * @return string 'No Meal Service'
     */
    const VALUE_NO_MEAL_SERVICE = 'No Meal Service';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BREAKFAST
     * @uses self::VALUE_SNACK
     * @uses self::VALUE_DINNER
     * @uses self::VALUE_HOT_MEAL
     * @uses self::VALUE_LUNCH
     * @uses self::VALUE_REFRESHMENTS
     * @uses self::VALUE_COMPLIMENTARY_LIQUOR
     * @uses self::VALUE_MEAL
     * @uses self::VALUE_LIQUOR_FOR_PURCHASE
     * @uses self::VALUE_FOOD_FOR_PURCHASE
     * @uses self::VALUE_COLD_MEAL
     * @uses self::VALUE_NO_MEAL_SERVICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BREAKFAST,
            self::VALUE_SNACK,
            self::VALUE_DINNER,
            self::VALUE_HOT_MEAL,
            self::VALUE_LUNCH,
            self::VALUE_REFRESHMENTS,
            self::VALUE_COMPLIMENTARY_LIQUOR,
            self::VALUE_MEAL,
            self::VALUE_LIQUOR_FOR_PURCHASE,
            self::VALUE_FOOD_FOR_PURCHASE,
            self::VALUE_COLD_MEAL,
            self::VALUE_NO_MEAL_SERVICE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
