<?php

namespace EnumType;

/**
 * This class stands for List_VehCategory_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Vehicle Category (VEC) OpenTravel codelist. | An open list of vehicle categories.
 * @subpackage Enumerations
 */
class List_VehCategory_Base
{
    /**
     * Constant for value '2WheelVehicle'
     * @return string '2WheelVehicle'
     */
    const VALUE_2_WHEEL_VEHICLE = '2WheelVehicle';
    /**
     * Constant for value 'All-Terrain'
     * @return string 'All-Terrain'
     */
    const VALUE_ALL_TERRAIN = 'All-Terrain';
    /**
     * Constant for value 'Car/Sedan'
     * @return string 'Car/Sedan'
     */
    const VALUE_CAR_SEDAN = 'Car/Sedan';
    /**
     * Constant for value 'Coach/Bus'
     * @return string 'Coach/Bus'
     */
    const VALUE_COACH_BUS = 'Coach/Bus';
    /**
     * Constant for value 'CommercialVan/Truck'
     * @return string 'CommercialVan/Truck'
     */
    const VALUE_COMMERCIAL_VAN_TRUCK = 'CommercialVan/Truck';
    /**
     * Constant for value 'Convertible'
     * @return string 'Convertible'
     */
    const VALUE_CONVERTIBLE = 'Convertible';
    /**
     * Constant for value 'Coupe'
     * @return string 'Coupe'
     */
    const VALUE_COUPE = 'Coupe';
    /**
     * Constant for value 'Crossover'
     * @return string 'Crossover'
     */
    const VALUE_CROSSOVER = 'Crossover';
    /**
     * Constant for value 'ExtendedCabPickup'
     * @return string 'ExtendedCabPickup'
     */
    const VALUE_EXTENDED_CAB_PICKUP = 'ExtendedCabPickup';
    /**
     * Constant for value 'Limo'
     * @return string 'Limo'
     */
    const VALUE_LIMO = 'Limo';
    /**
     * Constant for value 'Monospace'
     * @return string 'Monospace'
     */
    const VALUE_MONOSPACE = 'Monospace';
    /**
     * Constant for value 'Motorcycle'
     * @return string 'Motorcycle'
     */
    const VALUE_MOTORCYCLE = 'Motorcycle';
    /**
     * Constant for value 'Motorhome'
     * @return string 'Motorhome'
     */
    const VALUE_MOTORHOME = 'Motorhome';
    /**
     * Constant for value 'Pickup'
     * @return string 'Pickup'
     */
    const VALUE_PICKUP = 'Pickup';
    /**
     * Constant for value 'Recreational'
     * @return string 'Recreational'
     */
    const VALUE_RECREATIONAL = 'Recreational';
    /**
     * Constant for value 'RegularCabPickup'
     * @return string 'RegularCabPickup'
     */
    const VALUE_REGULAR_CAB_PICKUP = 'RegularCabPickup';
    /**
     * Constant for value 'Roadster'
     * @return string 'Roadster'
     */
    const VALUE_ROADSTER = 'Roadster';
    /**
     * Constant for value 'Shuttle'
     * @return string 'Shuttle'
     */
    const VALUE_SHUTTLE = 'Shuttle';
    /**
     * Constant for value 'Special'
     * @return string 'Special'
     */
    const VALUE_SPECIAL = 'Special';
    /**
     * Constant for value 'SpecialOffer'
     * @return string 'SpecialOffer'
     */
    const VALUE_SPECIAL_OFFER = 'SpecialOffer';
    /**
     * Constant for value 'Sport'
     * @return string 'Sport'
     */
    const VALUE_SPORT = 'Sport';
    /**
     * Constant for value 'StationWagon'
     * @return string 'StationWagon'
     */
    const VALUE_STATION_WAGON = 'StationWagon';
    /**
     * Constant for value 'SUV'
     * @return string 'SUV'
     */
    const VALUE_SUV = 'SUV';
    /**
     * Constant for value 'Truck'
     * @return string 'Truck'
     */
    const VALUE_TRUCK = 'Truck';
    /**
     * Constant for value 'Van'
     * @return string 'Van'
     */
    const VALUE_VAN = 'Van';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_2_WHEEL_VEHICLE
     * @uses self::VALUE_ALL_TERRAIN
     * @uses self::VALUE_CAR_SEDAN
     * @uses self::VALUE_COACH_BUS
     * @uses self::VALUE_COMMERCIAL_VAN_TRUCK
     * @uses self::VALUE_CONVERTIBLE
     * @uses self::VALUE_COUPE
     * @uses self::VALUE_CROSSOVER
     * @uses self::VALUE_EXTENDED_CAB_PICKUP
     * @uses self::VALUE_LIMO
     * @uses self::VALUE_MONOSPACE
     * @uses self::VALUE_MOTORCYCLE
     * @uses self::VALUE_MOTORHOME
     * @uses self::VALUE_PICKUP
     * @uses self::VALUE_RECREATIONAL
     * @uses self::VALUE_REGULAR_CAB_PICKUP
     * @uses self::VALUE_ROADSTER
     * @uses self::VALUE_SHUTTLE
     * @uses self::VALUE_SPECIAL
     * @uses self::VALUE_SPECIAL_OFFER
     * @uses self::VALUE_SPORT
     * @uses self::VALUE_STATION_WAGON
     * @uses self::VALUE_SUV
     * @uses self::VALUE_TRUCK
     * @uses self::VALUE_VAN
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_2_WHEEL_VEHICLE,
            self::VALUE_ALL_TERRAIN,
            self::VALUE_CAR_SEDAN,
            self::VALUE_COACH_BUS,
            self::VALUE_COMMERCIAL_VAN_TRUCK,
            self::VALUE_CONVERTIBLE,
            self::VALUE_COUPE,
            self::VALUE_CROSSOVER,
            self::VALUE_EXTENDED_CAB_PICKUP,
            self::VALUE_LIMO,
            self::VALUE_MONOSPACE,
            self::VALUE_MOTORCYCLE,
            self::VALUE_MOTORHOME,
            self::VALUE_PICKUP,
            self::VALUE_RECREATIONAL,
            self::VALUE_REGULAR_CAB_PICKUP,
            self::VALUE_ROADSTER,
            self::VALUE_SHUTTLE,
            self::VALUE_SPECIAL,
            self::VALUE_SPECIAL_OFFER,
            self::VALUE_SPORT,
            self::VALUE_STATION_WAGON,
            self::VALUE_SUV,
            self::VALUE_TRUCK,
            self::VALUE_VAN,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
