<?php

namespace EnumType;

/**
 * This class stands for List_TravelPurpose_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Travel Purpose (TVP) OpenTravel codelist. | An open list of travel purposes.
 * @subpackage Enumerations
 */
class List_TravelPurpose_Base
{
    /**
     * Constant for value 'Bereavment/Emergency'
     * @return string 'Bereavment/Emergency'
     */
    const VALUE_BEREAVMENT_EMERGENCY = 'Bereavment/Emergency';
    /**
     * Constant for value 'Business'
     * @return string 'Business'
     */
    const VALUE_BUSINESS = 'Business';
    /**
     * Constant for value 'BusinessAndPersonal'
     * @return string 'BusinessAndPersonal'
     */
    const VALUE_BUSINESS_AND_PERSONAL = 'BusinessAndPersonal';
    /**
     * Constant for value 'Charter/Group'
     * @return string 'Charter/Group'
     */
    const VALUE_CHARTER_GROUP = 'Charter/Group';
    /**
     * Constant for value 'Conference/Event'
     * @return string 'Conference/Event'
     */
    const VALUE_CONFERENCE_EVENT = 'Conference/Event';
    /**
     * Constant for value 'Personal'
     * @return string 'Personal'
     */
    const VALUE_PERSONAL = 'Personal';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BEREAVMENT_EMERGENCY
     * @uses self::VALUE_BUSINESS
     * @uses self::VALUE_BUSINESS_AND_PERSONAL
     * @uses self::VALUE_CHARTER_GROUP
     * @uses self::VALUE_CONFERENCE_EVENT
     * @uses self::VALUE_PERSONAL
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BEREAVMENT_EMERGENCY,
            self::VALUE_BUSINESS,
            self::VALUE_BUSINESS_AND_PERSONAL,
            self::VALUE_CHARTER_GROUP,
            self::VALUE_CONFERENCE_EVENT,
            self::VALUE_PERSONAL,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
