<?php

namespace EnumType;

/**
 * This class stands for List_ReservationBillingType_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Note: Typically used for rate plans that may be published, e.g. have no qualifying criteria, or may be restricted or negotiated, e.g. has qualifying criteria for eligibility and/or has been negotiated between parties. | Source: Rate
 * Plan Type (RPT) OpenTravel codelist. | An open list of reservation billing types.
 * @subpackage Enumerations
 */
class List_ReservationBillingType_Base
{
    /**
     * Constant for value 'Casino'
     * @return string 'Casino'
     */
    const VALUE_CASINO = 'Casino';
    /**
     * Constant for value 'Corporate'
     * @return string 'Corporate'
     */
    const VALUE_CORPORATE = 'Corporate';
    /**
     * Constant for value 'Group '
     * @return string 'Group '
     */
    const VALUE_GROUP = 'Group ';
    /**
     * Constant for value 'Individual'
     * @return string 'Individual'
     */
    const VALUE_INDIVIDUAL = 'Individual';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CASINO
     * @uses self::VALUE_CORPORATE
     * @uses self::VALUE_GROUP
     * @uses self::VALUE_INDIVIDUAL
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CASINO,
            self::VALUE_CORPORATE,
            self::VALUE_GROUP,
            self::VALUE_INDIVIDUAL,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
